/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsProxy;
import com.ats.element.FoundElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.executor.drivers.engines.browsers.capabilities.OperaOptions;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedValue;

public class OperaDriverEngine
extends WebDriverEngine {
    private boolean isLink = false;

    public OperaDriverEngine(Channel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, AtsProxy proxy, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, enableLearning);
        this.initElementX = 20.0;
        OperaOptions options = new OperaOptions(new BrowserArgumentsParser(driverInfo, channel.getArguments(), props, "opera", this.applicationPath, systemDriver), props, systemDriver, proxy);
        this.launchDriver(status, options);
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.isLink = element.getTag().toUpperCase().equals("A");
        super.mouseClick(status, element, position, offsetX, offsetY);
    }

    @Override
    protected void click(FoundElement element, double offsetX, double offsetY) {
        this.actions.moveToElement(element.getValue(), (int)offsetX, (int)offsetY).perform();
        this.actions.click(element.getValue()).perform();
    }

    @Override
    protected double getCartesianOffset(double value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        if (this.isLink && direction == null) {
            direction = new MouseDirectionData(Cartesian.TOP, new CalculatedValue("10"));
        }
        return super.getCartesianOffset(value, direction, cart1, cart2, cart3) + value / 2.0;
    }

    @Override
    protected void closeWindows() {
        if (this.driver != null) {
            try {
                this.driver.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.driver = null;
        }
    }
}

