/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.executor.ActionStatus;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.tools.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import com.opencsv.exceptions.CsvException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ParameterDataFile {
    public static final String CSV_TYPE = "csv";
    public static final String CSV_HEADER_TYPE = "csvHeader";
    public static final String JSON_TYPE = "json";
    public static final String PROPERTIES_TYPE = "properties";
    public static final String JSON_SIMPLE_TYPE = "jsonSimple";
    public static final String JSON_COMPLEX_TYPE = "jsonComplex";
    private String dataType = "csv";
    private ArrayList<ParameterList> data = new ArrayList();
    private boolean editable = true;
    private int maxCols = 0;
    private ActionStatus status;

    public ParameterDataFile() {
    }

    public ParameterDataFile(ActionStatus status, URL url) {
        this.status = status;
        this.editable = !url.getProtocol().startsWith("http");
        char[] buffer = new char[8192];
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
            int charsRead;
            while ((charsRead = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                result.append(buffer, 0, charsRead);
            }
        }
        catch (IOException e2) {
            status.setError(-24, e2.getMessage());
            return;
        }
        String content = Utils.cutBOM(result.toString());
        if (url.getPath().endsWith(".csv")) {
            this.readCsvData(content);
        } else if (url.getPath().endsWith(".properties")) {
            this.readPropertiesData(content);
        } else {
            JsonElement jsonElement = ParameterDataFile.getJsonElement(content);
            if (jsonElement != null) {
                if (jsonElement.isJsonArray()) {
                    this.dataType = JSON_COMPLEX_TYPE;
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    int iteration = 1;
                    for (JsonElement line : jsonArray) {
                        if (line.isJsonObject()) {
                            ParameterList newLine = new ParameterList(iteration);
                            AtomicInteger colIndex = new AtomicInteger(0);
                            line.getAsJsonObject().entrySet().forEach(e -> newLine.addParameter(new Parameter(colIndex.getAndIncrement(), (String)e.getKey(), (JsonElement)e.getValue())));
                            this.data.add(newLine);
                        }
                        ++iteration;
                    }
                } else if (jsonElement.isJsonObject()) {
                    this.dataType = JSON_TYPE;
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (jsonObject.has("paramNames") && jsonObject.has("paramValues") && jsonObject.size() == 2) {
                        try {
                            JsonArray paramNames = jsonObject.get("paramNames").getAsJsonArray();
                            JsonArray paramValues = jsonObject.get("paramValues").getAsJsonArray();
                            if (paramNames.size() == paramValues.size()) {
                                for (int i = 0; i < paramValues.size(); ++i) {
                                    JsonArray iterations = paramValues.get(i).getAsJsonArray();
                                    for (int j = 0; j < iterations.size(); ++j) {
                                        String paramName = "";
                                        if (i < paramNames.size()) {
                                            paramName = paramNames.get(i).getAsString();
                                        }
                                        if (this.data.size() < j + 1) {
                                            this.data.add(new ParameterList(this.data.size() + 1));
                                        }
                                        ParameterList row = this.data.get(j);
                                        row.addParameter(new Parameter(j, paramName, iterations.get(j).getAsString()));
                                    }
                                }
                                return;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    this.dataType = JSON_SIMPLE_TYPE;
                    this.parseJsonObject(jsonObject);
                }
            } else {
                this.readCsvData(content);
            }
        }
    }

    private void readPropertiesData(String content) {
        this.dataType = PROPERTIES_TYPE;
        StringReader reader = new StringReader(content);
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ParameterList plist = new ParameterList();
                int equalsPos = line.indexOf("=");
                if (equalsPos > 0) {
                    String key = line.substring(0, equalsPos);
                    String value = line.substring(equalsPos + 1);
                    plist.addParameter(new Parameter(0, key, value));
                }
                this.data.add(plist);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readCsvData(String content) {
        RFC4180Parser rfc4180Parser = new RFC4180ParserBuilder().build();
        CSVReader reader = new CSVReaderBuilder((Reader)new StringReader(content)).withCSVParser((ICSVParser)rfc4180Parser).build();
        try {
            List csvList = reader.readAll();
            reader.close();
            this.setMaxCols(this.data.size());
            String[] namedCols = null;
            if (csvList.size() > 0) {
                namedCols = this.getNamedCols((String[])csvList.get(0));
            }
            if (namedCols != null) {
                this.dataType = CSV_HEADER_TYPE;
                String[] cols = namedCols;
                AtomicInteger colIndex = new AtomicInteger(0);
                csvList.subList(1, csvList.size()).forEach(l -> ParameterDataFile.addCsvLine(this.data, colIndex.getAndIncrement(), cols, Arrays.asList(l)));
            } else {
                csvList.forEach(l -> ParameterDataFile.addCsvLine(this.data, l));
            }
        }
        catch (CsvException | IOException e) {
            this.status.setError(-24, e.getMessage());
        }
    }

    private String[] getNamedCols(String[] data) {
        String[] cols = new String[data.length];
        int i = 0;
        for (String col : data) {
            if (!(col = col.trim()).startsWith("<") || !col.endsWith(">")) {
                return null;
            }
            cols[i] = col.substring(1, col.length() - 1);
            ++i;
        }
        return cols;
    }

    private void parseJsonObject(JsonObject jsonObject) {
        AtomicInteger colIndex = new AtomicInteger(0);
        jsonObject.keySet().forEach(c -> ParameterDataFile.addCol(this.data, jsonObject, c, colIndex.getAndIncrement()));
    }

    private static void addCol(ArrayList<ParameterList> list, JsonObject obj, String colName, int colIndex) {
        JsonArray data = obj.get(colName).getAsJsonArray();
        AtomicInteger line = new AtomicInteger(0);
        data.forEach(e -> ParameterDataFile.addLine(list, e, line.getAndIncrement(), data, colName, colIndex));
    }

    private static void addLine(ArrayList<ParameterList> list, JsonElement elem, int line, JsonArray data, String colName, int colIndex) {
        if (elem != null && elem.isJsonPrimitive()) {
            if (list.size() < line + 1) {
                list.add(new ParameterList(list.size() + 1));
            }
            ParameterList currentLine = list.get(line);
            currentLine.addParameter(new Parameter(colIndex, colName, data.get(line).getAsString()));
        }
    }

    private static void addCsvLine(ArrayList<ParameterList> result, int lineIndex, String[] namedCols, List<String> lineData) {
        ParameterList newLine = new ParameterList(lineIndex + 1);
        AtomicInteger idx = new AtomicInteger(0);
        lineData.forEach(e -> newLine.addParameter(new Parameter(lineIndex, idx.getAndIncrement(), namedCols, lineData)));
        result.add(newLine);
    }

    private static void addCsvLine(ArrayList<ParameterList> result, String[] line) {
        AtomicInteger col = new AtomicInteger(0);
        result.add(new ParameterList(result.size() + 1, Arrays.stream(line).map(l -> new Parameter(col.getAndIncrement(), (String)l)).collect(Collectors.toList())));
    }

    private static JsonElement getJsonElement(String content) {
        try {
            return JsonParser.parseString((String)content);
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    public int getSize() {
        return this.data.size();
    }

    public ParameterList getData(int index) {
        if (this.getSize() > index) {
            return this.data.get(index);
        }
        if (this.getSize() > 0) {
            return this.data.get(0);
        }
        return null;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) {
        this.dataType = type;
    }

    public ArrayList<ParameterList> getData() {
        return this.data;
    }

    public void setData(ArrayList<ParameterList> list) {
        this.data = list;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getMaxCols() {
        return this.maxCols;
    }

    public void setMaxCols(int maxCols) {
        if (maxCols > this.maxCols) {
            this.maxCols = maxCols;
        }
    }
}

