/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform.code;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.io.IOAccess;

public class CodeEval {
    private static final String ERROR_CODE_EVAL = "#CodeEvalError#";
    private String type;
    private String code;

    public CodeEval(String type, String code) {
        this.type = type;
        this.code = code;
    }

    protected static Context getContext(ByteArrayOutputStream out, String type) {
        return Context.newBuilder((String[])new String[]{type}).engine(Engine.newBuilder().logHandler(OutputStream.nullOutputStream()).option("engine.WarnInterpreterOnly", "false").build()).useSystemExit(true).allowIO(IOAccess.ALL).allowAllAccess(true).out((OutputStream)out).build();
    }

    public String eval() {
        Object result = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (Context ct = CodeEval.getContext(outputStream, this.type);){
            ct.eval(this.type, (CharSequence)this.code);
            result = outputStream.toString();
        }
        catch (Exception e) {
            result = ERROR_CODE_EVAL + e.getMessage();
        }
        return ((String)result).replace("\n", "");
    }
}

