/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.ScriptStatus;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.recorder.RecorderSummaryData;
import com.ats.recorder.TestError;
import java.util.ArrayList;
import java.util.List;

public class TestSummary {
    public static final String EMPTY_VALUE = "[empty]";
    private int status = 1;
    private String summary = "";
    private String suiteName = "";
    private String testName = "";
    private int actions = 0;
    private TestError error;
    private List<TestError> errors;

    public void appendData(String value) {
        this.summary = this.summary + value + "<br>";
    }

    public void setFailData(String script, int line, String message, TestError.TestErrorStatus testErrorStatus) {
        this.status = 0;
        this.addError(script, line, message, testErrorStatus);
    }

    public void addFailPassData(String testName, int testLine, String errorMessage) {
        this.status = 0;
        this.addError(testName, testLine, errorMessage, TestError.TestErrorStatus.FAIL_PASS);
    }

    private void addError(String testName, int testLine, String errorMessage, TestError.TestErrorStatus testErrorStatus) {
        if (this.errors == null) {
            this.errors = new ArrayList<TestError>();
            this.errors.add(new TestError(testName, testLine, errorMessage, testErrorStatus));
        } else {
            if (TestError.TestErrorStatus.FAIL_STOP.equals((Object)testErrorStatus) && this.errors.stream().anyMatch(testError -> TestError.TestErrorStatus.FAIL_STOP.equals((Object)testError.getTestErrorStatus()))) {
                return;
            }
            this.errors.add(new TestError(testName, testLine, errorMessage, testErrorStatus));
        }
    }

    public RecorderSummaryData getRecordSummary(ScriptStatus st, IDriverInfo iDriverInfo) {
        RecorderSummaryData recordSummary = new RecorderSummaryData(st);
        if (this.summary == null || this.summary.isEmpty()) {
            this.summary = "";
        }
        recordSummary.setData(this.summary);
        recordSummary.setStatus(this.status);
        if (this.errors != null && !this.errors.isEmpty()) {
            TestError multiError = new TestError(this.errors);
            recordSummary.setError(multiError);
        }
        recordSummary.setDriverInfo(iDriverInfo);
        return recordSummary;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String value) {
        if (value == null) {
            value = "";
        }
        this.summary = value;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName.replaceFirst("suite::", "");
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName.replaceFirst("script::", "");
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public TestError getError() {
        return this.error;
    }

    public void setError(TestError error) {
        this.error = error;
    }

    public void setErrors(List<TestError> errors) {
        this.errors = errors;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }
}

