/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.performance;

import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.script.actions.performance.ActionPerformance;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class ActionPerformanceStart
extends ActionPerformance {
    public static final String SCRIPT_LABEL = "perf-start";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private long sendBandWidth = 0L;
    private long receiveBandWidth = 0L;
    private int latency = 0;
    private int trafficIdle = 0;
    private List<String> whiteList = null;
    private String filters = "";

    public ActionPerformanceStart() {
    }

    public ActionPerformanceStart(Script script, ExecuteOptions options, ArrayList<String> dataArray) {
        super(script, options);
        this.setWhiteList(dataArray.stream().map(String::trim).collect(Collectors.toList()));
        options.updateBandWidth(this);
    }

    public ActionPerformanceStart(Script script, ExecuteOptions options, int iddle, int ltcy, long sbw, long rbw, String[] whiteList) {
        super(script, options);
        this.setTrafficIdle(iddle);
        this.setSendBandWidth(sbw);
        this.setReceiveBandWidth(rbw);
        this.setWhiteList(Arrays.asList(whiteList));
    }

    @Override
    public StringBuilder getJavaCode() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String s : this.whiteList) {
            list.add((CallSite)((Object)("\"" + StringEscapeUtils.escapeJava((String)s) + "\"")));
        }
        return super.getJavaCode().append(this.trafficIdle).append(", ").append(this.latency).append(", ").append(this.sendBandWidth).append("L, ").append(this.receiveBandWidth).append("L, new String[]{").append(String.join((CharSequence)", ", list)).append("})");
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        this.getCurrentChannel().startHarServer(this.status, this.whiteList, this.trafficIdle, this.latency, this.sendBandWidth, this.receiveBandWidth);
        this.status.endDuration();
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public int getTrafficIdle() {
        return this.trafficIdle;
    }

    public void setTrafficIdle(int value) {
        this.trafficIdle = value;
    }

    public long getSendBandWidth() {
        return this.sendBandWidth;
    }

    public void setSendBandWidth(long value) {
        this.sendBandWidth = value;
    }

    public long getReceiveBandWidth() {
        return this.receiveBandWidth;
    }

    public void setReceiveBandWidth(long value) {
        this.receiveBandWidth = value;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> data) {
        this.whiteList = data;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }
}

