/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.logger;

import com.ats.script.actions.Action;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.logger.levels.ErrorLevelLogger;
import com.ats.tools.logger.levels.FullLevelLogger;
import com.ats.tools.logger.levels.InfoLevelLogger;
import com.ats.tools.logger.levels.WarningLevelLogger;
import java.io.PrintStream;
import org.testng.Reporter;

public class ExecutionLogger {
    public static final String SILENT = "silent";
    public static final String RIGHT_ARROW_LOG = " -> ";
    private static final String INFO_LEVEL = "info";
    private static final String ERROR_LEVEL = "error";
    private static final String ALL_LEVEL = "all";
    private static final String WARNING_LEVEL = "warning";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    private AtsLogger levelLogger;

    public ExecutionLogger() {
        this.levelLogger = new AtsLogger();
    }

    public ExecutionLogger(PrintStream sysout) {
        this(sysout, INFO_LEVEL, "term");
    }

    public ExecutionLogger(PrintStream sysout, String verbose, String type) {
        this.levelLogger = ERROR_LEVEL.equalsIgnoreCase(verbose) ? new ErrorLevelLogger(sysout, type, "Error") : (INFO_LEVEL.equalsIgnoreCase(verbose) ? new InfoLevelLogger(sysout, type, "Error + Info") : (WARNING_LEVEL.equalsIgnoreCase(verbose) ? new WarningLevelLogger(sysout, type, "Error + Info + Warning") : (ALL_LEVEL.equalsIgnoreCase(verbose) ? new FullLevelLogger(sysout, type, "Error + Info + Warning + Details") : new AtsLogger(sysout, type, "Disabled"))));
    }

    public void sendLog(int code, String message, Object value) {
        if (code < 100) {
            this.sendInfo(message, value.toString());
        } else if (code < 399) {
            this.sendWarning(message, value.toString());
        } else {
            this.sendError(message, value.toString());
        }
    }

    public void sendScriptInfo(String message) {
        this.levelLogger.printScript(message);
        Reporter.log((String)("- " + message));
    }

    public void sendScriptFail(String actionName, String testName, int line, String app, String message) {
        this.levelLogger.printFail(actionName, testName, line, app, message);
        Reporter.log((String)("- " + message));
    }

    public void sendScriptError(String info, String value) {
        this.levelLogger.printError(info, value);
    }

    public void sendAction(Action action, String testName, int line) {
        this.levelLogger.action(action, testName, line);
    }

    public void sendComment(String message) {
        this.levelLogger.comment(message);
        Reporter.log((String)("- " + message));
    }

    public void sendWarning(int code, String message, Object value) {
        this.levelLogger.warning(message + RIGHT_ARROW_LOG + value);
    }

    public void sendWarning(String message, String value) {
        this.levelLogger.warning(message + RIGHT_ARROW_LOG + value);
    }

    public void sendInfo(String message, String value) {
        this.levelLogger.info(message + RIGHT_ARROW_LOG + value);
    }

    public void sendError(String message, String value) {
        this.levelLogger.error(message, value);
    }

    public void sendDriverLog(String value) {
        this.levelLogger.driverLog(value);
    }

    public void sendDriverWarning(String value) {
        this.levelLogger.driverWarning(value);
    }

    public void sendDriverError(String value) {
        this.levelLogger.driverError(value);
    }

    public void sendDriverOutput(String value) {
        this.levelLogger.driverOutput(value);
    }

    public void sendScriptSuite(String value) {
        this.levelLogger.suiteOutput(value);
    }

    public void sendScriptTest(String value) {
        this.levelLogger.testOutput(value);
    }
}

