/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.generator.ATS;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.MinifyWriter;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.XmlReport;
import com.ats.tools.report.analytics.TestsResultBarChart;
import com.ats.tools.report.utils.AdvancedAtsLogger;
import com.ats.tools.report.utils.FileUtils;
import com.ats.tools.report.utils.ImageProcessingUtils;
import com.ats.tools.report.utils.MemoryMonitor;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CampaignReportGenerator {
    private static final String HTML_HEADER = "<html><head><title>ats-report</title><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/><script type=\"text/javascript\">\n" + ResourceContent.getJasperReportScript() + "</script><style type=\"text/css\">" + ResourceContent.getJasperReportCss() + "</style></head><body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\"><table role=\"none\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\r\n<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">" + ResourceContent.getJasperReportHtmlContent();
    public static final String AGILITEST_RESOURCES_PREFIX = "AgilitestResources";
    public static final String ATS_JSON_SUITES = "ats-suites.json";
    public static final String ATS_REPORT = "ats-report";
    public static final String ATS_TEST_REPORT = "ats-test-report";
    public static final String ATS_REPORT_ENV = "ATS_REPORT";
    public static final String MGT_REPORT = "mgt-report";
    public static final String VALID_REPORT = "validation-report";
    public static final String TEMPLATE_EXTENSION = "_html.xml";
    private static final String REPORT_FOLDER = "reports";
    private static final String TEMPLATE_FOLDER = "templates";
    private static final String IMAGE_FOLDER = "images";
    private static final String CUSTOM_TEMPLATES_FOLDER = "/reports/templates/";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private static final String XML_SOURCE_ROOT = "ats-report";
    private static final String XML_SOURCE_NAME = "ats-report.xml";
    public static final String ATS_REPORT_HTML = "ats-report.html";
    public static final String ATS_TEST_REPORT_HTML = "ats-test-report.html";
    private static int details = 0;
    public static int DETAILS_AND_SCREEN = 3;
    private static final List<String> trueList = Arrays.asList("on", "true", "1", "yes", "y");
    private long reportGenerationStartTime;

    public static void main(String[] args) {
        String output = null;
        List<String> listArgs = Arrays.asList(args);
        if (listArgs.contains("--help") || listArgs.contains("-h") || listArgs.contains("--h") || listArgs.contains("/?") || listArgs.contains("\\?")) {
            CampaignReportGenerator.usage();
            return;
        }
        block13: for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (!string.startsWith("--") || i + 1 >= args.length) continue;
            switch (string.substring(2)) {
                case "outputFolder": 
                case "output": 
                case "reportFolder": {
                    output = args[i + 1].replaceAll("\"", "");
                    continue block13;
                }
                case "details": 
                case "atsReport": {
                    details = Utils.string2Int(args[i + 1], 0);
                }
            }
        }
        if (output == null) {
            System.out.println("Error, output folder not defined !");
            return;
        }
        Path outputFolderPath = Paths.get(output, new String[0]).toAbsolutePath();
        if (!outputFolderPath.toFile().exists()) {
            System.out.println("Error, output folder path not found : " + output);
            return;
        }
        File jsonSuiteFilesFile = outputFolderPath.resolve(ATS_JSON_SUITES).toFile();
        if (jsonSuiteFilesFile.exists()) {
            try {
                new CampaignReportGenerator(outputFolderPath, jsonSuiteFilesFile, details);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Suites file not found : ats-suites.json");
        }
    }

    private static void usage() {
        System.out.print("Usage : Experiment dev\nThis class is use to extract data from ATSV, convert and generate to other documents (HTML, PDF)\n\nParameters usage :\n\t--output\t\t\t(mandatory)(absolute or relative path) : parameter used to\n\t  outputFolder\t\tspecify the input and output folder of generated folder\n\t  reportFolder\t\t\n\t--jasper\t\t\t(optional)(absolute or relative path) : parameter used to specify\n\t\t\t\t\t\tthe folder of jasper software. If this one isn't specified\n\t\t\t\t\t\tthe PDF report isn't generated\n\t--details\t\t\t(optional) : specify the dev report  verbosity\n\t  atsReport\t\t(0: disable, 1: standard, 2: detailed, 3: 2 + screenshots\n\n\n\n\n");
    }

    public static void initFolders(Path projectPath) {
        try {
            projectPath.resolve(REPORT_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_TEMPLATES_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_IMAGES_FOLDER).toFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copyReportsTemplate(Path path, Path toPath) {
        if (Files.exists(path, new LinkOption[0])) {
            for (File f : path.toFile().listFiles()) {
                if (!f.isFile()) continue;
                try {
                    Files.copy(f.toPath(), toPath.resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public CampaignReportGenerator(Path outputFolderPath, File jsonSuiteFilesFile, int devReportLevel) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        int tmp;
        String[] defaultImages;
        File[] filesToDelete;
        MemoryMonitor memoryMonitor = new MemoryMonitor();
        memoryMonitor.startMonitoring();
        this.reportGenerationStartTime = System.nanoTime();
        Timer timer = AdvancedAtsLogger.displayMessageWithPeriodExecutionTimeAndMemoryUsed("report generation in progress -> ", 30, this.reportGenerationStartTime);
        LinkedList<String> reports = new LinkedList<String>();
        Path reportPath = Paths.get("src", "assets", "resources", REPORT_FOLDER);
        if (Files.exists(reportPath, new LinkOption[0])) {
            this.copyReportsTemplate(reportPath.resolve(TEMPLATE_FOLDER), outputFolderPath);
            this.copyReportsTemplate(reportPath.resolve(IMAGE_FOLDER), outputFolderPath);
        }
        SuitesReport suiteReport = null;
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFilesFile));
            suiteReport = (SuitesReport)new Gson().fromJson(reader, SuitesReport.class);
            reader.close();
        }
        catch (IOException reader) {
            // empty catch block
        }
        if (suiteReport == null) {
            System.out.println("no suites found, nothing to do !");
            return;
        }
        Path outputPath = outputFolderPath.toAbsolutePath();
        for (File f : filesToDelete = outputFolderPath.toFile().listFiles(new FilenameFilter(this){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jrprint") || name.endsWith(".jasper") || name.endsWith(".pdf");
            }
        })) {
            try {
                f.delete();
                System.out.println("file: " + f.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Path outputJasperFolder = outputFolderPath.resolve("ats-jasper");
        try {
            Utils.deleteRecursive(outputJasperFolder.toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Files.createDirectory(outputJasperFolder, new FileAttribute[0]);
        CampaignReportGenerator.copyResource("test.jrxml", outputJasperFolder);
        CampaignReportGenerator.copyResource("suite.jrxml", outputJasperFolder);
        CampaignReportGenerator.copyResource("summary.jrxml", outputJasperFolder);
        CampaignReportGenerator.copyResource("ats-test.jrxml", outputJasperFolder);
        CampaignReportGenerator.copyResource("ats-test-action.jrxml", outputJasperFolder);
        try {
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("test.jrxml").toString(), (String)outputJasperFolder.resolve("test.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("suite.jrxml").toString(), (String)outputJasperFolder.resolve("suite.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("summary.jrxml").toString(), (String)outputJasperFolder.resolve("summary.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("ats-test.jrxml").toString(), (String)outputJasperFolder.resolve("ats-test.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("ats-test-action.jrxml").toString(), (String)outputJasperFolder.resolve("ats-test-action.jasper").toString());
            AtsLogger.printLog("JASPER reports templates generated");
        }
        catch (JRException e) {
            AtsLogger.printLog("error generating jasper files -> " + e.getMessage());
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document writeXmlDocument = builder.newDocument();
        Element report = writeXmlDocument.createElement("ats-report");
        report.setAttribute("atsVersion", ATS.getAtsVersion());
        report.setAttribute("projectId", suiteReport.projectId);
        report.setAttribute("projectUuid", suiteReport.projectUuid);
        report.setAttribute("projectName", suiteReport.projectName);
        report.setAttribute("projectVersion", suiteReport.projectVersion);
        report.setAttribute("projectDescription", suiteReport.projectDescription);
        report.setAttribute("path", outputFolderPath.toFile().toURI().toASCIIString());
        report.setAttribute("started", String.valueOf(suiteReport.started));
        report.setAttribute("startedFormated", OffsetDateTime.ofInstant(Instant.ofEpochMilli(suiteReport.started), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH:mm:ss")));
        report.setAttribute("startedFormatedZulu", OffsetDateTime.ofInstant(Instant.ofEpochMilli(suiteReport.started), ZoneOffset.UTC).toString());
        writeXmlDocument.appendChild(report);
        Element picsList = writeXmlDocument.createElement("pics");
        for (String img : defaultImages = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "api.png", "pdf.png", "external_link_10_white.png", "external_link_12_blue.png", "external_link_12_blue_visited.png", "external_link_12_grey.png", "external_link_16_grey.png", "external_link_16_white.png", "run_16.png"}) {
            Element pic = writeXmlDocument.createElement("pic");
            pic.setAttribute("name", img.replace(".png", ""));
            byte[] imgBytes = null;
            imgBytes = Files.exists(outputFolderPath.resolve(img), new LinkOption[0]) ? Files.readAllBytes(outputFolderPath.resolve(img)) : ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + img).readAllBytes();
            pic.setTextContent("data:image/png;base64," + CampaignReportGenerator.getBase64DefaultImages(imgBytes));
            picsList.appendChild(pic);
        }
        report.appendChild(picsList);
        report.setAttribute("suitesCount", String.valueOf(suiteReport.suites.length));
        int totalTestsPassed = 0;
        int totalTestsFailed = 0;
        int totalSuitesPassed = 0;
        int totalActions = 0;
        int totalDuration = 0;
        String SATSReport = System.getProperty("ats-report");
        String SVALIDReport = System.getProperty(VALID_REPORT);
        String SATSReportEnv = System.getenv(ATS_REPORT_ENV);
        String devReportLVL = "0";
        if (SATSReportEnv != null && !"0".equals(SATSReportEnv)) {
            tmp = Utils.string2Int(SATSReportEnv, 0);
            if (tmp > 0 && tmp < 4) {
                devReportLVL = SATSReportEnv;
            } else {
                System.out.println("[WARN] incorrect env variable value [ATS_REPORT] : " + SATSReportEnv);
            }
        }
        if (SATSReport != null && !"0".equals(SATSReport)) {
            tmp = Utils.string2Int(SATSReport, 0);
            if (tmp > 0 && tmp < 4) {
                devReportLVL = SATSReport;
            } else {
                System.out.println("[WARN] incorrect parameters value [ats-report] : " + SATSReport);
            }
        } else {
            devReportLVL = Integer.toString(details);
        }
        report.setAttribute("devReportLevel", devReportLVL);
        report.setAttribute("validReportLevel", SVALIDReport);
        for (SuitesReportItem info : suiteReport.suites) {
            Element groupXml;
            Path suitePath = outputFolderPath.resolve(info.getName());
            boolean suitePassed = true;
            Element suite = writeXmlDocument.createElement("suite");
            suite.setAttribute("name", info.getName());
            suite.setAttribute("started", String.valueOf(System.currentTimeMillis()));
            int devReport = 0;
            devReport = Utils.string2Int(SATSReport, details);
            boolean validReport = false;
            if (SVALIDReport != null) {
                boolean bl = validReport = trueList.indexOf(SVALIDReport.toLowerCase()) > -1;
            }
            if (SATSReport != null && !"0".equals(SATSReport)) {
                devReport = Utils.string2Int(SATSReport, 0);
                if (devReport == 0) {
                    System.out.println("cmd parameter value error [ats-report] : " + SATSReport);
                }
            } else if (SATSReportEnv != null && !"0".equals(SATSReportEnv)) {
                devReport = Utils.string2Int(SATSReportEnv, 0);
                if (devReport == 0) {
                    System.out.println("env parameter value error [ATS_REPORT] : " + SATSReportEnv);
                }
            } else if (!"0".equals(info.devReportLvl) && (devReport = Utils.string2Int(info.devReportLvl, details)) == 0) {
                System.out.println("[ERROR] suite parameter value [ats.report.dev.level] : " + info.devReportLvl);
            }
            if (!(SVALIDReport != null && "0".equals(SVALIDReport) || "".equals(info.validReportLvl) || validReport || !"true".equals(info.validReportLvl))) {
                validReport = true;
            }
            String reportName = "suites_html.xml";
            if (devReport != 0 && !reports.contains(reportName)) {
                reports.add(reportName);
            }
            reportName = "validation-report_html.xml";
            if (validReport && !reports.contains(reportName)) {
                reports.add(reportName);
            }
            suite.setAttribute("description", info.getDescription());
            suite.setAttribute("dateOrder", info.getDateOrder());
            Element parameters = writeXmlDocument.createElement("parameters");
            suite.appendChild(parameters);
            Properties properties = new Properties();
            Path suiteParamPath = suitePath.resolve("parameters.txt");
            if (Files.exists(suiteParamPath, new LinkOption[0])) {
                properties.load(Files.newBufferedReader(suiteParamPath));
            }
            Element imageQuality = writeXmlDocument.createElement("parameter");
            imageQuality.setAttribute("name", "ats-image-quality");
            imageQuality.setAttribute("value", String.valueOf(info.getVisualQualityLabel()));
            parameters.appendChild(imageQuality);
            if (info.getDateOrder() != null && info.getDateOrder().length() > 0) {
                Element dateOrder = writeXmlDocument.createElement("parameter");
                dateOrder.setAttribute("name", "ats-date-order");
                dateOrder.setAttribute("value", String.valueOf(info.getDateOrder()));
                parameters.appendChild(dateOrder);
            }
            for (Map.Entry entry : info.getParametersEntries()) {
                Element parameter = writeXmlDocument.createElement("parameter");
                parameter.setAttribute("name", (String)entry.getKey());
                parameter.setAttribute("value", properties.getProperty((String)entry.getKey(), (String)entry.getValue()));
                parameter.setAttribute("defaultValue", (String)entry.getValue());
                parameters.appendChild(parameter);
            }
            Element groups = writeXmlDocument.createElement("groups");
            for (String group : info.getIncludedGroups()) {
                groupXml = writeXmlDocument.createElement("included");
                groupXml.setTextContent(group);
                groups.appendChild(groupXml);
            }
            for (String group : info.getExcludedGroups()) {
                groupXml = writeXmlDocument.createElement("excluded");
                groupXml.setTextContent(group);
                groups.appendChild(groupXml);
            }
            suite.appendChild(groups);
            Element element = writeXmlDocument.createElement("tests");
            suite.appendChild(element);
            int testsPassed = 0;
            int testsFailed = 0;
            int actionsExecuted = 0;
            int suiteDuration = 0;
            suite.setAttribute("testsCount", String.valueOf(info.getTestsCount()));
            suite.setAttribute("started", String.valueOf(info.getStarted()));
            suite.setAttribute("startedFormated", OffsetDateTime.ofInstant(Instant.ofEpochMilli(info.getStarted()), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH:mm:ss")));
            suite.setAttribute("startedFormatedZulu", OffsetDateTime.ofInstant(Instant.ofEpochMilli(info.getStarted()), ZoneOffset.UTC).toString());
            SimpleHtmlExporterConfiguration configuration = new SimpleHtmlExporterConfiguration();
            configuration.setHtmlHeader(HTML_HEADER);
            for (String className : info.tests) {
                Path testResultPath = suitePath.resolve(className + "_xml");
                File xmlDataFile = testResultPath.resolve(XmlReport.REPORT_DATA_FILE).toFile();
                if (!xmlDataFile.exists() || !xmlDataFile.isFile()) continue;
                int testDuration = 0;
                Element atsTest = builder.parse(xmlDataFile).getDocumentElement();
                NodeList actionsList = atsTest.getElementsByTagName("action");
                int testActionsExecuted = actionsList.getLength();
                NodeList summary = atsTest.getElementsByTagName("summary");
                atsTest.setAttribute("devReportLVL", devReportLVL);
                if (summary.getLength() > 0) {
                    if ("1".equals(summary.item(0).getAttributes().getNamedItem("status").getNodeValue())) {
                        ++testsPassed;
                        ++totalTestsPassed;
                    } else {
                        ++testsFailed;
                        ++totalTestsFailed;
                        suitePassed = false;
                    }
                    testActionsExecuted = Utils.string2Int(summary.item(0).getAttributes().getNamedItem("actions").getNodeValue(), testActionsExecuted);
                }
                actionsExecuted += testActionsExecuted;
                for (int i = 0; i < actionsList.getLength(); ++i) {
                    Node action = actionsList.item(i);
                    Element eElement = (Element)action;
                    Node element2 = null;
                    element2 = eElement.getElementsByTagName("duration").item(0);
                    if (element2 != null) {
                        testDuration += Utils.string2Int(element2.getTextContent());
                    }
                    element2 = null;
                }
                atsTest.setAttribute("duration", String.valueOf(testDuration));
                suiteDuration += testDuration;
                element.appendChild(writeXmlDocument.importNode(atsTest, true));
                String atsTestReportPath = testResultPath.resolve(ATS_TEST_REPORT_HTML).toString();
                try {
                    String xmlDataFileCopyPath;
                    String agilitestTempResourcesPath;
                    NodeList imgs = atsTest.getElementsByTagName("img");
                    try {
                        FileUtils.clearTempDir(AGILITEST_RESOURCES_PREFIX);
                        agilitestTempResourcesPath = Files.createTempDirectory(AGILITEST_RESOURCES_PREFIX, new FileAttribute[0]).toFile().getAbsolutePath();
                        Path copied = Paths.get(agilitestTempResourcesPath + File.separator + xmlDataFile.getName(), new String[0]);
                        Path original = Paths.get(xmlDataFile.getPath(), new String[0]);
                        xmlDataFileCopyPath = Files.copy(original, copied, StandardCopyOption.REPLACE_EXISTING).toString();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    ImageProcessingUtils.processImages(imgs, agilitestTempResourcesPath);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    StreamResult output = new StreamResult(new File(xmlDataFileCopyPath));
                    DOMSource input = new DOMSource(atsTest);
                    transformer.transform(input, output);
                    AtsLogger.printLog("create ats-test report -> " + atsTestReportPath);
                    JRSwapFile swapFile = new JRSwapFile(System.getProperty("java.io.tmpdir"), 1024, 1024);
                    JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(2, swapFile, true);
                    HashMap<String, String> testReportParameters = new HashMap<String, String>();
                    testReportParameters.put("xmlSource", xmlDataFileCopyPath);
                    testReportParameters.put("reportLevel", devReportLVL);
                    testReportParameters.put("REPORT_VIRTUALIZER", (String)virtualizer);
                    JasperPrint jasperPrint = JasperFillManager.fillReport((String)outputJasperFolder.resolve("ats-test.jasper").toString(), testReportParameters);
                    HtmlExporter exporter = new HtmlExporter();
                    exporter.getPropertiesUtil().setProperty("net.sf.jasperreports.export.html.embed.image", "true");
                    SimpleHtmlExporterOutput outputHtml = new SimpleHtmlExporterOutput(atsTestReportPath);
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporter.setExporterOutput((ExporterOutput)outputHtml);
                    exporter.setConfiguration((ExporterConfiguration)configuration);
                    exporter.exportReport();
                    outputHtml.close();
                    File agilitestTempResourceFile = Path.of(agilitestTempResourcesPath, new String[0]).toFile();
                    ImageProcessingUtils.processVideos(atsTestReportPath, agilitestTempResourceFile, agilitestTempResourcesPath);
                    FileUtils.deleteFolder(agilitestTempResourceFile);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            totalActions += actionsExecuted;
            totalDuration += suiteDuration;
            if (suitePassed) {
                ++totalSuitesPassed;
            }
            suite.setAttribute("passed", String.valueOf(suitePassed));
            suite.setAttribute("duration", String.valueOf(suiteDuration));
            suite.setAttribute("actions", String.valueOf(actionsExecuted));
            suite.setAttribute("testsPassed", String.valueOf(testsPassed));
            suite.setAttribute("testsFailed", String.valueOf(testsFailed));
            TestsResultBarChart bar = new TestsResultBarChart(testsPassed, testsFailed, info.getTestsCount() - testsPassed - testsFailed);
            suite.setAttribute("resultBar", bar.getBase64());
            report.appendChild(suite);
        }
        report.setAttribute("duration", String.valueOf(totalDuration));
        report.setAttribute("tests", String.valueOf(totalTestsPassed + totalTestsFailed));
        report.setAttribute("testsPassed", String.valueOf(totalTestsPassed));
        report.setAttribute("testsFailed", String.valueOf(totalTestsFailed));
        report.setAttribute("suitesPassed", String.valueOf(totalSuitesPassed));
        report.setAttribute("actions", String.valueOf(totalActions));
        Path atsXmlDataPath = outputFolderPath.resolve(XML_SOURCE_NAME);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(writeXmlDocument), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(atsXmlDataPath.toFile()), StandardCharsets.UTF_8)));
        for (String reportFile : reports) {
            File htmlTemplateFile = CampaignReportGenerator.copyResource(reportFile, outputFolderPath);
            MinifyWriter filteredWriter = null;
            Transformer htmlTransformer = null;
            if ("suites_html.xml".equals(reportFile)) {
                filteredWriter = new MinifyWriter(Files.newBufferedWriter(outputFolderPath.resolve(ATS_REPORT_HTML), StandardCharsets.UTF_8, new OpenOption[0]));
                htmlTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(htmlTemplateFile));
            } else {
                filteredWriter = new MinifyWriter(Files.newBufferedWriter(outputFolderPath.resolve(reportFile.substring(0, reportFile.indexOf("_")) + ".html"), StandardCharsets.UTF_8, new OpenOption[0]));
                htmlTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(htmlTemplateFile));
            }
            htmlTransformer.setOutputProperty("encoding", "UTF-8");
            htmlTransformer.transform(new DOMSource(builder.parse(new InputSource(new InputStreamReader(Files.newInputStream(atsXmlDataPath, new OpenOption[0]), StandardCharsets.UTF_8)))), new StreamResult(filteredWriter));
            filteredWriter.close();
        }
        try {
            String reportFullName = outputPath.resolve("summary.pdf").toString();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("workingDir", outputJasperFolder.toString());
            parameters.put("xmlSource", outputPath.resolve(XML_SOURCE_NAME).toString());
            parameters.put("xmlSourceRoot", "ats-report");
            String fileName = JasperFillManager.fillReportToFile((String)outputJasperFolder.resolve("summary.jasper").toString(), parameters);
            JasperExportManager.exportReportToPdfFile((String)fileName, (String)reportFullName);
            AtsLogger.printLog("PDF file -> " + reportFullName + " ... OK");
            AtsLogger.printLog("report generated in " + (System.nanoTime() - this.reportGenerationStartTime) / 1000000000L + " second(s)");
            timer.cancel();
            long maxMemoryUsed = memoryMonitor.stopMonitoring();
            AtsLogger.printLog("maximum memory used during report generation -> " + maxMemoryUsed + " MB");
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private static File copyResource(String resName, Path dest) throws IOException {
        Path filePath = dest.resolve(resName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            int lengthRead;
            InputStream is = ResourceContent.class.getResourceAsStream(CUSTOM_TEMPLATES_FOLDER + resName);
            BufferedInputStream in = new BufferedInputStream(is);
            File targetFile = dest.resolve(resName).toFile();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
                ((OutputStream)out).flush();
            }
            ((InputStream)in).close();
            is.close();
            ((OutputStream)out).close();
        }
        return filePath.toFile();
    }

    private static String getBase64DefaultImages(byte[] b) throws IOException {
        return Base64.getEncoder().encodeToString(b);
    }
}

