/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.executor.TestBound;
import com.ats.flex.messaging.amf.io.AMF3Deserializer;
import com.ats.recorder.TestError;
import com.ats.recorder.TestSummary;
import com.ats.recorder.VisualAction;
import com.ats.recorder.VisualElement;
import com.ats.recorder.VisualReport;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class HtmlPlayerReport {
    private static Map<String, String> executionData = new HashMap<String, String>();
    private static Map<String, String> testData = new HashMap<String, String>();
    private static Map<String, String> actionData = new HashMap<String, String>();
    private static Map<String, String> actionsData = new HashMap<String, String>();
    private static Map<String, String> iconsData = new HashMap<String, String>();
    private static Map<String, String> customImg = new HashMap<String, String>();
    private static Map<String, String> actionsImg = new HashMap<String, String>();
    private static final String REPORT_FOLDER = "reports";
    private static final String IMAGE_FOLDER = "images";
    private static final String HTML_FOLDER = "playerHTML";
    private static final String CUSTOM_TEMPLATES_FOLDER = "/reports/playerHTML/";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private static String c_testName = "";
    private static final Path reportPath = Paths.get("src", "assets", "resources", "reports");
    private static final Path imagesPath = Paths.get(reportPath.toString(), "images");
    private static final String[] imagesList = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "api.png", "pdf.png", "watermark.png"};
    private static final String CUSTOM_GSAP_FOLDER = "/reports/playerHTML/gsap_file/";
    private static final String CSS_FILE_NAME = "open.css";
    private static final String GSAP_FILE_NAME = "gsap_3.11.1.min.js";
    private static final String GSAP_STP_FILE_NAME = "ScrollToPlugin_3.11.1.min.js";
    private static final String JSCODE_FILE_NAME = "script.js";
    private static boolean developper = false;
    private static PrintWriter devData = null;
    private static PrintWriter devImg = null;
    private static final String HTML_TEMPLATE_NAME = "player_tpl.html";
    private static final String HTML_PLAYER_NAME = "atsv.html";
    static Path outputFolder;
    static Path inputFolder;

    public static void main(String[] args) throws IOException {
        List<String> listArgs = Arrays.asList(args);
        if (args.length == 0 || listArgs.contains("--help") || listArgs.contains("-h") || listArgs.contains("--h") || listArgs.contains("/?") || listArgs.contains("\\?")) {
            HtmlPlayerReport.usage();
            return;
        }
        String testName = null;
        boolean iconsConvert = false;
        boolean execution = false;
        block16: for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            if (!param.startsWith("--")) continue;
            switch (param.substring(2)) {
                case "outputFolder": 
                case "output": {
                    if (i + 1 < args.length) {
                        outputFolder = Path.of(args[i + 1].replaceAll("\"", ""), new String[0]);
                    }
                    execution = true;
                    continue block16;
                }
                case "input": 
                case "inputFolder": {
                    if (i + 1 < args.length) {
                        inputFolder = Path.of(args[i + 1].replaceAll("\"", ""), new String[0]);
                    }
                    execution = true;
                    continue block16;
                }
                case "testName": {
                    c_testName = testName = args[i + 1];
                    execution = true;
                    continue block16;
                }
                case "iconsConvert": {
                    iconsConvert = true;
                    continue block16;
                }
                case "dev": {
                    developper = true;
                    continue block16;
                }
                default: {
                    System.out.println("\u001b[31munrecognized parameter : \u001b[0m" + param);
                    HtmlPlayerReport.usage();
                    return;
                }
            }
        }
        if (iconsConvert) {
            System.out.println("iconsData Js file started");
            HtmlPlayerReport.writeJSIconsFile();
            System.out.println("iconsData Js file ended");
        }
        if (execution) {
            if (inputFolder != null && inputFolder.toFile().isDirectory()) {
                if (outputFolder == null || !outputFolder.toFile().isDirectory()) {
                    System.out.println("output folder not specified or unavailabled \n\tinput folder used like output Folder");
                    outputFolder = inputFolder;
                }
                if (testName != null && inputFolder.resolve(testName + ".atsv").toFile().exists()) {
                    HtmlPlayerReport.createHTMLPlayerReport(new ExecutionLogger(System.out), inputFolder, testName, outputFolder);
                } else {
                    System.out.println("[ERROR] invalid suite name. GENETRATION ABORTED");
                }
            } else {
                System.out.println("[ERROR] input folder doesn't exist. GENETRATION ABORTED");
            }
        }
    }

    private static void usage() {
        System.out.print("Usage : Experiment dev\nThis class is use to extract data from ATSV, convert and generate to a html_player\n\nParameters usage (case sensitive):\n\t--inputFolder\t\t(mandatory)(absolute or relative path) : parameter used to specify\n\t  input\t\t\t\tthe input folder where the system can find the ATSV file\n\t--testName\t\t\t(mandatory) : ATSV file name without extension\n\t--outputFolder\t\t(optional)(absolute or relative path) : parameter used to\n\t  output\t\t\tspecify the output folder of generated player\n\n\n\n\n");
    }

    public static void createHTMLPlayerReport(ExecutionLogger logger, Path in, String qualifiedName, Path ... out) {
        File atsvFile;
        actionsData = new HashMap<String, String>();
        executionData = new HashMap<String, String>();
        testData = new HashMap<String, String>();
        actionsImg = new HashMap<String, String>();
        if (in == null || !in.toFile().isDirectory()) {
            logger.sendError("input folder doesn't exist", in != null ? in.toString() : "");
            return;
        }
        outputFolder = out.length > 0 ? out[0] : in;
        if (qualifiedName != "") {
            c_testName = qualifiedName;
        }
        if ((atsvFile = in.resolve(qualifiedName + ".atsv").toFile()).exists()) {
            File xmlFolder = in.resolve(qualifiedName + "_xml").toFile();
            logger.sendInfo("create Atsv-Html player report", xmlFolder.getAbsolutePath());
            try {
                try {
                    FileInputStream fis = new FileInputStream(atsvFile);
                    AMF3Deserializer amf3 = new AMF3Deserializer((InputStream)fis);
                    VisualReport report = (VisualReport)amf3.readObject();
                    HtmlPlayerReport.reportDataStruct(report);
                    HtmlPlayerReport.testDataStruct(report);
                    int actionsNum = 0;
                    try {
                        amf3.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    while (amf3.available() > 0) {
                        Object obj = amf3.readObject();
                        if (obj instanceof VisualAction) {
                            VisualAction va = (VisualAction)obj;
                            actionData = new HashMap<String, String>();
                            HtmlPlayerReport.actionDataStruct(va);
                            VisualElement ve = va.getElement();
                            if (ve != null) {
                                HtmlPlayerReport.addActionData("element", HtmlPlayerReport.elementDataStruct(ve));
                            }
                            HtmlPlayerReport.addActionsDataStruct(String.valueOf(actionsNum), HtmlPlayerReport.getStringElement(actionData, false));
                            HtmlPlayerReport.addActionsImg(String.valueOf(actionsNum), HtmlPlayerReport.imagesDataStruct(va));
                            ++actionsNum;
                            continue;
                        }
                        if (!(obj instanceof TestSummary)) continue;
                        TestSummary reportSummary = (TestSummary)obj;
                        HtmlPlayerReport.summaryStruct(reportSummary);
                    }
                }
                catch (IOException e1) {
                    logger.sendError("ATSV report file error ->", e1.getMessage());
                }
                catch (Exception e2) {
                    logger.sendError("ATSV report exception ->", e2.getMessage());
                }
            }
            catch (Exception e4) {
                logger.sendError("ATSV report parser error ->", e4.getMessage());
            }
            HtmlPlayerReport.copyRessources(logger);
            HtmlPlayerReport.extractFolderIcons("reports/playerHTML/icons", "png");
            HtmlPlayerReport.extractFolderIcons("reports/playerHTML/icons", "gif");
            HtmlPlayerReport.addDefaultRessources();
            HtmlPlayerReport.writeHTMLFile();
            logger.sendInfo("HTML_player generated", xmlFolder.getAbsolutePath());
        } else {
            logger.sendError("no ATSV file, XML actions file cannot be generated", atsvFile.getAbsolutePath());
        }
    }

    private static void reportDataStruct(VisualReport report) {
        executionData.put("cpuSpeed", HtmlPlayerReport.JSData(report.getCpuSpeed()));
        executionData.put("cpuCount", HtmlPlayerReport.JSData(report.getCpuCount()));
        executionData.put("totalMemory", HtmlPlayerReport.JSData(report.getTotalMemory()));
        executionData.put("osInfo", HtmlPlayerReport.JSData(report.getOsInfo()));
    }

    private static void testDataStruct(VisualReport report) {
        testData.put("testId", HtmlPlayerReport.JSData(report.getId()));
        testData.put("testName", HtmlPlayerReport.JSData(report.getScript()));
        testData.put("externalId", HtmlPlayerReport.JSData(report.getExternalId()));
        testData.put("description", HtmlPlayerReport.JSData(report.getDescription()));
        testData.put("author", HtmlPlayerReport.JSData(report.getAuthor()));
        testData.put("prerequisite", HtmlPlayerReport.JSData(report.getPrerequisite()));
        testData.put("started", HtmlPlayerReport.JSData(Long.valueOf(report.getStarted())));
        testData.put("quality", HtmlPlayerReport.JSData(report.getQuality()));
        testData.put("groups", HtmlPlayerReport.JSData(report.getGroups()));
    }

    private static void addTestData(String key, String value) {
        testData.put(key, value);
    }

    private static void addActionData(String key, String value) {
        actionData.put(key, value);
    }

    private static void actionDataStruct(VisualAction va) {
        actionData.put("index", HtmlPlayerReport.JSData(va.getIndex()));
        actionData.put("type", HtmlPlayerReport.JSData(va.getType()));
        actionData.put("line", HtmlPlayerReport.JSData(va.getLine()));
        actionData.put("script", HtmlPlayerReport.JSData(va.getScript()));
        actionData.put("timeLine", HtmlPlayerReport.JSData(va.getTimeLine()));
        actionData.put("error", HtmlPlayerReport.JSData(va.getError()));
        actionData.put("stop", HtmlPlayerReport.JSData(va.isStop()));
        actionData.put("duration", HtmlPlayerReport.JSData(va.getDuration()));
        actionData.put("passed", HtmlPlayerReport.JSData(va.getError() == 0));
        actionData.put("value", HtmlPlayerReport.JSData(va.getValue()));
        actionData.put("data", HtmlPlayerReport.JSData(va.getData()));
        actionData.put("Channel", HtmlPlayerReport.channelDataStruct(va));
    }

    private static void addActionsDataStruct(String key, String value) {
        actionsData.put(key, value);
    }

    private static void addActionsImg(String key, String value) {
        actionsImg.put(key, value);
    }

    private static String imagesDataStruct(VisualAction va) {
        HashMap<String, String> imagesData = new HashMap<String, String>();
        imagesData.put("imageType", HtmlPlayerReport.JSData(va.getImageType()));
        HashMap<String, String> imageData = new HashMap<String, String>();
        int index = 0;
        for (byte[] img : va.getImages()) {
            if (img == null) continue;
            imageData.put(String.valueOf(index), HtmlPlayerReport.JSData(Base64.getEncoder().encodeToString(img)));
            ++index;
        }
        imagesData.put("numImages", HtmlPlayerReport.JSData(index));
        imagesData.put("imagesPool", HtmlPlayerReport.getStringElement(imageData, false));
        return HtmlPlayerReport.getStringElement(imagesData, false);
    }

    private static String channelDataStruct(VisualAction va) {
        HashMap<String, String> channelData = new HashMap<String, String>();
        channelData.put("name", HtmlPlayerReport.JSData(va.getChannelName()));
        channelData.put("bound", HtmlPlayerReport.boundDataStruct(va.getChannelBound()));
        return HtmlPlayerReport.getStringElement(channelData, false);
    }

    private static String boundDataStruct(TestBound bound) {
        HashMap<String, String> boundData = new HashMap<String, String>();
        boundData.put("x", HtmlPlayerReport.JSData(bound.getX().intValue()));
        boundData.put("y", HtmlPlayerReport.JSData(bound.getY().intValue()));
        boundData.put("width", HtmlPlayerReport.JSData(bound.getWidth().intValue()));
        boundData.put("height", HtmlPlayerReport.JSData(bound.getHeight().intValue()));
        return HtmlPlayerReport.getStringElement(boundData, false);
    }

    private static String elementDataStruct(VisualElement ve) {
        HashMap<String, String> elementData = new HashMap<String, String>();
        elementData.put("tag", HtmlPlayerReport.JSData(ve.getTag()));
        elementData.put("criterias", HtmlPlayerReport.JSData(ve.getCriterias()));
        elementData.put("foundElements", HtmlPlayerReport.JSData(ve.getFoundElements()));
        elementData.put("searchDuration", HtmlPlayerReport.JSData(ve.getSearchDuration()));
        elementData.put("bound", HtmlPlayerReport.boundDataStruct(ve.getRectangle()));
        if (ve.getHpos() != null && ve.getVpos() != null) {
            elementData.put("extra", "{hPos : " + HtmlPlayerReport.JSData(ve.getHpos()) + ",hVal : " + HtmlPlayerReport.JSData(ve.getHposValue()) + ",vPos : " + HtmlPlayerReport.JSData(ve.getVpos()) + ",vVal : " + HtmlPlayerReport.JSData(ve.getVposValue()) + "}");
        }
        return HtmlPlayerReport.getStringElement(elementData, false);
    }

    private static void summaryStruct(TestSummary summary) {
        HtmlPlayerReport.addTestData("actions", HtmlPlayerReport.JSData(summary.getActions()));
        HtmlPlayerReport.addTestData("suiteName", HtmlPlayerReport.JSData(summary.getSuiteName()));
        HtmlPlayerReport.addTestData("status", HtmlPlayerReport.JSData(summary.getStatus()));
        HtmlPlayerReport.addTestData("data", HtmlPlayerReport.JSData(summary.getSummary()));
        if (summary.getStatus() == 0 && summary.getError() != null) {
            TestError scriptError = summary.getError();
            HtmlPlayerReport.addTestData("error", "{\nscript : " + HtmlPlayerReport.JSData(scriptError.getScriptLine()) + ", line : " + HtmlPlayerReport.JSData(scriptError.getLine()) + ", message : " + HtmlPlayerReport.JSData(scriptError.getMessage()) + "\n}");
        }
    }

    private static String JSData(Object obj) {
        Object data = "";
        if (obj instanceof String) {
            Object tmp = (String)obj;
            if (((String)tmp).lastIndexOf("\\") != -1 && ((String)tmp).lastIndexOf("\\") == ((String)tmp).length() - 1) {
                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2) + "&#92;";
            }
            StringBuilder SB = new StringBuilder();
            SB.append("\"").append(((String)tmp).replaceAll("\"", "'")).append("\"");
            data = SB.toString();
        } else {
            data = obj instanceof Integer || obj instanceof Long ? String.valueOf(obj) : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : "\"\"");
        }
        return StandardCharsets.UTF_8.decode(StandardCharsets.UTF_8.encode((String)data)).toString();
    }

    private static String getStringElement(Map<String, String> data, boolean enter) {
        StringBuilder stringData = new StringBuilder("{");
        Set<String> elements = data.keySet();
        boolean first = true;
        for (String element : elements) {
            String value = data.get(element);
            if (!first) {
                stringData.append(",");
            } else {
                first = false;
            }
            if (enter) {
                stringData.append("\n");
            }
            stringData.append(element).append(" : ").append(value);
        }
        if (stringData.length() == 1) {
            return null;
        }
        return stringData.append("}").toString();
    }

    private static void writeHTMLFile() {
        try {
            String line;
            PrintWriter htmlOPS = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFolder.resolve(HtmlPlayerReport.getHtmlPlayerName(c_testName)).toFile()), StandardCharsets.UTF_8));
            if (developper) {
                String date = new SimpleDateFormat("yyyy-MM-dd_hh-mm").format(new Date(Long.valueOf(testData.get("started"))));
                Path devPath = Paths.get(outputFolder.toString() + "\\" + date, new String[0]);
                System.out.println("path dev folder :" + devPath.toString());
                Files.createDirectories(devPath, new FileAttribute[0]);
                devData = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(devPath.resolve("data.js").toFile()), StandardCharsets.UTF_8));
                devImg = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(devPath.resolve("img.js").toFile()), StandardCharsets.UTF_8));
            }
            try {
                Files.deleteIfExists(outputFolder.resolve(HTML_TEMPLATE_NAME));
            }
            catch (IOException e) {
                htmlOPS.close();
                throw new RuntimeException(e);
            }
            FileInputStream htmlIPStream = new FileInputStream(HtmlPlayerReport.copyResource(HTML_TEMPLATE_NAME, outputFolder));
            BufferedReader htmlTemplate = new BufferedReader(new InputStreamReader(htmlIPStream));
            while ((line = htmlTemplate.readLine()) != null) {
                StringBuilder data;
                if (line.contains("!%ATS%GSAP%ATS%!")) {
                    HtmlPlayerReport.writeIntegratedFile(htmlOPS, "script", GSAP_FILE_NAME, CUSTOM_GSAP_FOLDER);
                    continue;
                }
                if (line.contains("!%ATS%GSAP_STP%ATS%!")) {
                    HtmlPlayerReport.writeIntegratedFile(htmlOPS, "script", GSAP_STP_FILE_NAME, CUSTOM_GSAP_FOLDER);
                    continue;
                }
                if (line.contains("!%ATS%CSS%ATS%!")) {
                    HtmlPlayerReport.writeIntegratedFile(htmlOPS, "style", CSS_FILE_NAME, new String[0]);
                    continue;
                }
                if (line.contains("!%ATS%JSCODE%ATS%!")) {
                    HtmlPlayerReport.writeIntegratedFile(htmlOPS, "script", JSCODE_FILE_NAME, new String[0]);
                    continue;
                }
                if (line.contains("!%ATS%JSICONS%ATS%!")) {
                    data = new StringBuilder();
                    data.append("const icons = ").append(HtmlPlayerReport.getStringElement(iconsData, true)).append("\n");
                    htmlOPS.write("\t<script > // auto-generated section\n");
                    htmlOPS.write(data.toString());
                    htmlOPS.write("\n\t /* end of auto-integrated section */ </script>\n\n");
                    continue;
                }
                if (line.contains("!%ATS%JSDATA%ATS%!")) {
                    data = new StringBuilder();
                    data.append("const execution = " + HtmlPlayerReport.getStringElement(executionData, false) + "\n");
                    data.append("const test = " + HtmlPlayerReport.getStringElement(testData, false) + "\n");
                    data.append("const actions = " + HtmlPlayerReport.getStringElement(actionsData, true) + "\n");
                    data.append("const customsImg = " + HtmlPlayerReport.getStringElement(customImg, true) + "\n");
                    data.append("dataLoaded = true;\n");
                    htmlOPS.write("\t<script > // auto-generated section\n");
                    htmlOPS.write(data.toString());
                    htmlOPS.write("\n\t /* end of auto-integrated section */ </script>\n\n");
                    htmlOPS.flush();
                    if (!developper || devData == null) continue;
                    devData.write(data.toString());
                    devData.flush();
                    continue;
                }
                if (line.contains("!%ATS%JSIMG%ATS%!")) {
                    HtmlPlayerReport.writeImgStock(htmlOPS);
                    continue;
                }
                htmlOPS.write(line);
                htmlOPS.write(10);
                htmlOPS.flush();
            }
            ((InputStream)htmlIPStream).close();
            htmlTemplate.close();
            htmlOPS.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Files.deleteIfExists(outputFolder.resolve(HTML_TEMPLATE_NAME));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (developper) {
            if (devData != null) {
                devData.close();
            }
            if (devImg != null) {
                devImg.close();
            }
        }
    }

    public static String getHtmlPlayerName(String name) {
        StringBuilder sb = new StringBuilder(name).append("_").append(HTML_PLAYER_NAME);
        return sb.toString();
    }

    private static File copyResource(String resName, Path dest) {
        Path filePath = dest.resolve(resName);
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                int lengthRead;
                InputStream is = ResourceContent.class.getResourceAsStream(CUSTOM_TEMPLATES_FOLDER + resName);
                BufferedInputStream in = new BufferedInputStream(is);
                File targetFile = dest.resolve(resName).toFile();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] buffer = new byte[1024];
                while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, lengthRead);
                    ((OutputStream)out).flush();
                }
                ((InputStream)in).close();
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return filePath.toFile();
    }

    private static long writeIntegratedFile(PrintWriter out, String type, String fileToIntegrate, String ... specificInputPath) {
        String inputResourceFolder = "";
        inputResourceFolder = specificInputPath.length > 0 ? specificInputPath[0] : CUSTOM_TEMPLATES_FOLDER;
        InputStream is = ResourceContent.class.getResourceAsStream(inputResourceFolder + fileToIntegrate);
        BufferedInputStream in = new BufferedInputStream(is);
        byte[] buffer = new byte[1024];
        long byteRead = -1L;
        out.write("\n\t<" + type + "> /* auto-integrated section */ \n");
        out.flush();
        try {
            int lengthRead;
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                byteRead += (long)lengthRead;
                String line = new String(buffer);
                line = lengthRead != 1024 ? line.substring(0, lengthRead - 1) : line;
                out.write(line);
                out.flush();
                buffer = new byte[1024];
            }
            out.write("\n\t/* end of auto-integrated section */ </" + type + ">\n");
            out.flush();
            ((InputStream)in).close();
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteRead;
    }

    private static void writeJSIconsFile() {
        BufferedOutputStream IconsOPS = null;
        try {
            IconsOPS = new BufferedOutputStream(new FileOutputStream(Path.of("T:\\env\\ATS\\ats-core\\src\\main\\resources\\reports\\playerHTML\\icons\\iconsData.js", new String[0]).toFile()));
            ArrayList iconsPath = new ArrayList();
            HashMap<String, String> icons = new HashMap<String, String>();
            HashMap<String, String> data = new HashMap<String, String>();
            Files.list(new File(String.valueOf(inputFolder) + "player\\32").toPath()).forEach(path -> {
                iconsPath.add(path.toString());
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("player_32", HtmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\32").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_32", HtmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\24").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_24", HtmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\20").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_20", HtmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\16").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_16", HtmlPlayerReport.getStringElement(icons, true));
            ((OutputStream)IconsOPS).write("const icons = ".getBytes());
            ((OutputStream)IconsOPS).write(HtmlPlayerReport.getStringElement(data, true).getBytes());
            ((OutputStream)IconsOPS).write(10);
            ((OutputStream)IconsOPS).flush();
            ((OutputStream)IconsOPS).write(10);
            ((OutputStream)IconsOPS).flush();
            ((OutputStream)IconsOPS).close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeImgStock(PrintWriter outputFile) {
        int size = actionsImg.size();
        StringBuilder imgData = new StringBuilder();
        for (int index = 0; index < size; ++index) {
            imgData = new StringBuilder();
            outputFile.write("<script>");
            imgData.append("imgStock[" + String.valueOf(index) + "] = " + actionsImg.get(String.valueOf(index)) + ";\n");
            imgData.append("imgStockLoaded = " + String.valueOf(index + 1) + ";");
            outputFile.write(imgData.toString());
            outputFile.write("</script>\n");
            outputFile.flush();
            if (!developper || devImg == null) continue;
            devImg.write(imgData.toString());
            devImg.flush();
        }
    }

    private static void copyRessources(ExecutionLogger logger) {
        if (Files.exists(imagesPath, new LinkOption[0])) {
            for (String img : imagesList) {
                HtmlPlayerReport.copyRessourcesImage(logger, imagesPath.resolve(img));
            }
        } else {
            logger.sendInfo("No image folder found", imagesPath.toString());
        }
    }

    private static void extractFolderIcons(String prePath, String ext) {
        List<String> resToCopy = HtmlPlayerReport.extractJarFolderRessourcesPath(prePath, ext);
        while (!resToCopy.isEmpty()) {
            String subPath = resToCopy.get(0).substring(0, resToCopy.get(0).lastIndexOf("/"));
            int loopSize = resToCopy.size();
            int index = 0;
            HashMap<String, String> icons = new HashMap<String, String>();
            while (index < loopSize) {
                String path = resToCopy.get(index);
                String subPathData = path.substring(0, path.lastIndexOf("/"));
                if (subPathData.startsWith(subPath)) {
                    byte[] imgBytes = null;
                    try {
                        imgBytes = ResourceContent.class.getResourceAsStream("/" + path).readAllBytes();
                        String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                        icons.put(fileName.replaceAll("/", "_").replaceAll("-", "_"), HtmlPlayerReport.JSData("data:image/" + ext + ";base64," + HtmlPlayerReport.getBase64DefaultImages(imgBytes)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    resToCopy.remove(path);
                    --loopSize;
                    continue;
                }
                ++index;
            }
            String key = subPath.replace(prePath, "").substring(1).replaceAll("/", "_");
            if (iconsData.containsKey(key)) {
                String data = iconsData.get(key).substring(2, iconsData.get(key).lastIndexOf("}"));
                String[] table = data.split(",\n");
                for (int iconInd = 0; iconInd < table.length; ++iconInd) {
                    String ligne = table[iconInd];
                    int indCar = ligne.indexOf(":");
                    String iconName = ligne.substring(0, indCar - 1);
                    String iconData = iconInd == table.length - 1 ? ligne.substring(indCar + 1) : ligne.substring(indCar + 2);
                    icons.put(iconName, iconData);
                }
            }
            iconsData.put(key, HtmlPlayerReport.getStringElement(icons, true));
        }
    }

    private static void copyRessourcesImage(ExecutionLogger logger, Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            File f = path.toFile();
            if (f.isFile()) {
                String fileName = f.getName().substring(0, f.getName().lastIndexOf("."));
                String imgData = HtmlPlayerReport.getImg64(path.getParent(), f.getName());
                customImg.put(fileName.replaceAll("-", "_"), HtmlPlayerReport.JSData(imgData));
            } else {
                logger.sendInfo("path is not a file", path.toString());
            }
        }
    }

    private static List<String> extractJarFolderRessourcesPath(String prePathFolder, String ext) {
        CodeSource src = ResourceContent.class.getProtectionDomain().getCodeSource();
        ArrayList<String> list = new ArrayList<String>();
        if (src != null) {
            URL jar = src.getLocation();
            ZipInputStream zip = null;
            try {
                zip = new ZipInputStream(jar.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ZipEntry ze = null;
            while (true) {
                try {
                    ze = zip.getNextEntry();
                    if (ze == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String entryName = ze.getName();
                if (!entryName.startsWith(prePathFolder) || !entryName.endsWith("." + ext)) continue;
                list.add(entryName);
            }
        }
        return list;
    }

    private static String getImg64(Path path, String imgFileName) {
        Object imgFile = "";
        byte[] imgBytes = null;
        String format = imgFileName.substring(imgFileName.lastIndexOf(".") + 1);
        if (Files.exists(path.resolve(imgFileName), new LinkOption[0])) {
            try {
                format = imgFileName.substring(imgFileName.lastIndexOf(".") + 1);
                imgBytes = Files.readAllBytes(path.resolve(imgFileName));
                imgFile = "data:image/" + format + ";base64," + HtmlPlayerReport.getBase64DefaultImages(imgBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            imgBytes = ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + imgFileName).readAllBytes();
            imgFile = "data:image/" + format + ";base64," + HtmlPlayerReport.getBase64DefaultImages(imgBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return imgFile;
    }

    private static String getBase64DefaultImages(byte[] b) throws IOException {
        return Base64.getEncoder().encodeToString(b);
    }

    private static void addDefaultRessources() {
        byte[] imgBytes = null;
        try {
            imgBytes = ResourceContent.class.getResourceAsStream("/reports/images/watermark.png").readAllBytes();
            customImg.put("defaultWM", HtmlPlayerReport.JSData("data:image/png;base64," + HtmlPlayerReport.getBase64DefaultImages(imgBytes)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

