/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.report.actions.HtmlReportActionKeyValueTemplate;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.HtmlReportProject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HtmlReportActionCallScript {
    private static final String ACTION_CALL_SCRIPT_HEADER = "${header1}";
    private static final String ACTION_CALL_SCRIPT = "${value1}";
    private static final String ACTION_CALL_SCRIPT_PARAMETERS_HEADER = "${header2}";
    private static final String ACTION_CALL_SCRIPT_PARAMETERS_VALUE = "${value2}";
    public static final String ATS_CALL_SCRIPT_HTML_TEMPLATE = "<a class='hover-underline' style='color: rgba(104, 112, 125, 1); display: flex; align-items: center;' href='ats://${scriptNameUri}' target='_self'><div class='external-link-icon'></div>${scriptName}</a>";
    private String template;
    private String result;

    public HtmlReportActionCallScript(String template, Action action, boolean hasParameters, HtmlReportProject project) {
        this.template = template;
        this.result = template.replace(ACTION_CALL_SCRIPT_HEADER, "SubScript called");
        this.result = this.result.replace(ACTION_CALL_SCRIPT, this.buildScriptUrl(action, project));
        if (hasParameters) {
            if (action.getActionElement() == null) {
                this.result = this.result.replace(ACTION_CALL_SCRIPT_PARAMETERS_HEADER, "Parameters");
                HashMap assetsMap = new HashMap();
                Set entries = action.getAppDataJson().getData().entrySet().stream().filter(stringStringEntry -> !((String)stringStringEntry.getValue()).equals("\u00d8")).collect(Collectors.toSet());
                entries.stream().peek(stringStringEntry -> {
                    if (((String)stringStringEntry.getKey()).equals("asset")) {
                        String asset = ((String)stringStringEntry.getValue()).replace("assets:///", "");
                        String assetWithUri = ATS_CALL_SCRIPT_HTML_TEMPLATE.replace("${scriptNameUri}", project.getProjectId() + "/asset/" + asset).replace("${scriptName}", asset);
                        stringStringEntry.setValue(assetWithUri);
                    }
                }).forEach(stringStringEntry -> assetsMap.put((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue()));
                this.result = assetsMap.containsKey("asset") ? this.result.replace(ACTION_CALL_SCRIPT_PARAMETERS_VALUE, String.join((CharSequence)"", assetsMap.values())) : this.result.replace(ACTION_CALL_SCRIPT_PARAMETERS_VALUE, HtmlReportActionKeyValueTemplate.buildEntireKeyValueString(assetsMap.entrySet().stream().sorted(Comparator.comparing(o -> Integer.valueOf((String)o.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)), true));
            } else {
                this.result = this.result.replace(ACTION_CALL_SCRIPT_PARAMETERS_HEADER, "Parameters");
                this.result = this.result.replace(ACTION_CALL_SCRIPT_PARAMETERS_VALUE, action.getActionElement().getCriterias());
            }
        }
    }

    private CharSequence buildScriptUrl(Action action, HtmlReportProject project) {
        return ATS_CALL_SCRIPT_HTML_TEMPLATE.replace("${scriptNameUri}", project.getProjectId() + "/script/" + action.getValue()).replace("${scriptName}", action.getValue());
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getResult() {
        return this.result;
    }
}

