/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.OperatorsWithIcons;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionChannel {
    private static final String CHANNEL_NAME_HEADER = "${header1}";
    private static final String CHANNEL_NAME = "${value1}";
    private static final String APPLICATION_HEADER = "${header2}";
    private static final String APPLICATION = "${value2}";
    private static final String APPLICATION_VERSION_HEADER = "${header3}";
    private static final String APPLICATION_VERSION = "${value3}";
    private static final String APPLICATION_ICON_TEMPLATE = "<img style='margin-right: 10px' src='data:image/png;base64,${appIcon}' alt='Application icon'>";
    private static final String SWITCH_CHANNEL_HTML_TEMPLATE = "<div>${oldChannel}</div>${operator}<div>${newChannel}</div>";
    private static final String APP_ICON = "${appIcon}";
    private static final String APP_NAME = "${appName}";
    private String template;
    private String result;

    public HtmlReportActionChannel(String template, Action action, ActionChannelOperation actionChannelOperation, Map<String, String> appIcons) {
        this.template = template;
        if (actionChannelOperation.equals((Object)ActionChannelOperation.CHANNEL_CHANGE)) {
            this.result = template.replace(CHANNEL_NAME_HEADER, "Switch channel");
            this.result = action.getChannel() != null ? this.result.replace(CHANNEL_NAME, this.buildSwitchChannelString(action)) : this.result.replace(CHANNEL_NAME, "");
        } else if (action.getAppDataJson() != null && action.getChannel() != null) {
            Object applicationName = action.getAppDataJson().getApp();
            String appIcon = appIcons.get(action.getAppDataJson().getApp());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appIcon})) {
                applicationName = APPLICATION_ICON_TEMPLATE.replace(APP_ICON, appIcon) + action.getAppDataJson().getApp();
            }
            this.result = template.replace(CHANNEL_NAME_HEADER, "Channel name");
            this.result = this.result.replace(CHANNEL_NAME, action.getAppDataJson().getName());
            this.result = this.result.replace(APPLICATION_HEADER, "Application");
            this.result = this.result.replace(APPLICATION, (CharSequence)applicationName);
            if (actionChannelOperation.equals((Object)ActionChannelOperation.CHANNEL_START)) {
                this.result = this.result.replace(APPLICATION_VERSION_HEADER, "Version");
                if (action.getAppDataJson().getAppVersion() != null) {
                    this.result = this.result.replace(APPLICATION_VERSION, action.getAppDataJson().getAppVersion());
                }
            }
        } else {
            this.result = template.replace(CHANNEL_NAME_HEADER, "Channel name");
            this.result = this.result.replace(CHANNEL_NAME, "");
            this.result = this.result.replace(APPLICATION_HEADER, "Application");
            this.result = this.result.replace(APPLICATION, "");
            if (actionChannelOperation.equals((Object)ActionChannelOperation.CHANNEL_START)) {
                this.result = this.result.replace(APPLICATION_VERSION_HEADER, "Version");
                this.result = this.result.replace(APPLICATION_VERSION, "");
            }
        }
    }

    private CharSequence buildSwitchChannelString(Action action) {
        return SWITCH_CHANNEL_HTML_TEMPLATE.replace("${oldChannel}", action.getChannel().getName()).replace("${newChannel}", action.getValue()).replace("${operator}", OperatorsWithIcons.getIconForOperator("ARROW"));
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getResult() {
        return this.result;
    }

    public static enum ActionChannelOperation {
        CHANNEL_START,
        CHANNEL_CLOSE,
        CHANNEL_CHANGE;

    }
}

