/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import com.ats.tools.report.analytics.ActionTypesEnum;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ActionsType {
    private static final Color GRID_COLOR = Color.decode("#5a6886");
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final Color NAVIGATION_COLOR = Color.decode("#1BBC9B");
    private static final Color SUBSCRIPT_COLOR = Color.decode("#3498DB");
    private static final Color USER_ACTION_COLOR = Color.decode("#72B500");
    private static final Color ASSERT_COLOR = Color.decode("#EE6AB9");
    private static final Color TECHNICAL_COLOR = Color.decode("#6E4AD3");
    private static final Color OTHER_COLOR = Color.decode("#7D7D7D");
    private DefaultCategoryDataset dataSet;
    private int navigationCount = 0;
    private int callScriptCount = 0;
    private int userActionCount = 0;
    private int assertCount = 0;
    private int technicalCount = 0;
    private int others = 0;

    public ActionsType() {
        this.dataSet = new DefaultCategoryDataset();
    }

    public ActionsType(int mouseCount, int textCount, int assertCount, int otherCount) {
    }

    public void addActionType(String type) {
        switch (ActionTypesEnum.of(type)) {
            case NAVIGATION: {
                ++this.navigationCount;
                break;
            }
            case CALL_SCRIPT: {
                ++this.callScriptCount;
                break;
            }
            case USER_ACTION: {
                ++this.userActionCount;
                break;
            }
            case ASSERT: {
                ++this.assertCount;
                break;
            }
            case TECHNICAL: {
                ++this.technicalCount;
                break;
            }
            case SSA: {
                break;
            }
            default: {
                ++this.others;
            }
        }
    }

    public String getBase64Chart() {
        this.dataSet.addValue((double)this.navigationCount, (Comparable)((Object)"Navigation"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.callScriptCount, (Comparable)((Object)"Callscript"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.userActionCount, (Comparable)((Object)"User action"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.assertCount, (Comparable)((Object)"Assertion"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.technicalCount, (Comparable)((Object)"Technical"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.others, (Comparable)((Object)"Others"), (Comparable)((Object)"s1"));
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)NAVIGATION_COLOR);
        renderer.setSeriesPaint(1, (Paint)SUBSCRIPT_COLOR);
        renderer.setSeriesPaint(2, (Paint)USER_ACTION_COLOR);
        renderer.setSeriesPaint(3, (Paint)ASSERT_COLOR);
        renderer.setSeriesPaint(4, (Paint)TECHNICAL_COLOR);
        renderer.setSeriesPaint(5, (Paint)OTHER_COLOR);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setShadowVisible(false);
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.getLegend().setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.getDomainAxis().setVisible(false);
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.setOutlinePaint(null);
        float[] dash1 = new float[]{1.0f, 0.0f, 2.0f};
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.3f, 0, 1, 1.0f, dash1, 2.0f));
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        NumberAxis range = (NumberAxis)plot.getRangeAxis();
        range.setTickUnit(new NumberTickUnit(2.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(230, 120));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)230, (int)120);
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

