/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TestsResultBarChart {
    private static final Color FAIL_COLOR = Color.decode("#35535E");
    private static final Color PASS_COLOR = Color.decode("#9CBF3F");
    private static final Color SKIP_COLOR = Color.decode("#ECF0DF");
    private DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
    private static StandardCategoryItemLabelGenerator labelGen = new StandardCategoryItemLabelGenerator("{0} ({2})", new DecimalFormat("0"), new DecimalFormat("0%")){

        public String generateLabel(CategoryDataset dataset, int row, int column) {
            if (dataset.getValue(row, column).intValue() == 0) {
                return null;
            }
            return super.generateLabel(dataset, row, column);
        }
    };

    public TestsResultBarChart(int pass, int fail, int skip) {
        this.dataSet.addValue((double)pass, (Comparable)((Object)"passed"), (Comparable)((Object)"0"));
        this.dataSet.addValue((double)fail, (Comparable)((Object)"failed"), (Comparable)((Object)"0"));
        this.dataSet.addValue((double)skip, (Comparable)((Object)"filtered"), (Comparable)((Object)"0"));
    }

    public String getBase64() {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)this.dataSet, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setRenderAsPercentages(true);
        renderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)labelGen);
        renderer.setDefaultItemLabelsVisible(true);
        renderer.setSeriesPaint(0, (Paint)PASS_COLOR);
        renderer.setSeriesPaint(1, (Paint)FAIL_COLOR);
        renderer.setSeriesPaint(2, (Paint)SKIP_COLOR);
        renderer.setSeriesItemLabelPaint(0, (Paint)Color.WHITE);
        renderer.setSeriesItemLabelPaint(1, (Paint)Color.WHITE);
        renderer.setSeriesItemLabelPaint(2, (Paint)FAIL_COLOR);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setFixedLegendItems(null);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        plot.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        plot.getDomainAxis().setVisible(false);
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.setOutlinePaint(null);
        chart.getCategoryPlot().setRangeGridlinesVisible(false);
        chart.setBorderVisible(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(600, 36));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)600, (int)36);
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

