/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.script.Project;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Script;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jfree.data.json.impl.JSONArray;
import org.jfree.data.json.impl.JSONObject;

public class FileUtils {
    private static final String jpegTypeHex = "FFFFFFFFFFFFFFD8FFFFFFFFFFFFFF";
    private static final String pngTypeHex = "FFFFFF89504E47";
    private static final String mpegTypeHex = "00018";

    public static String getFileType(String base64Data) {
        Object dataTypeInHex = "";
        byte[] decode = Base64.getDecoder().decode(base64Data);
        for (int i = 0; i <= 3; ++i) {
            dataTypeInHex = (String)dataTypeInHex + Integer.toHexString(decode[i]).toUpperCase();
        }
        if (((String)dataTypeInHex).startsWith(jpegTypeHex)) {
            return "jpeg";
        }
        if (((String)dataTypeInHex).startsWith(pngTypeHex)) {
            return "png";
        }
        if (((String)dataTypeInHex).startsWith(mpegTypeHex)) {
            return "mpeg";
        }
        throw new RuntimeException("Wrong file format detected.");
    }

    public static List<Path> listFiles(Path path, String extension) throws IOException {
        List<Path> result;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            result = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(extension)).collect(Collectors.toList());
        }
        return result;
    }

    public static void deleteFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                FileUtils.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            AtsLogger.printLog("failed to delete: " + folder.getPath());
        }
    }

    public static void clearTempDir(String agilitestResourcesPrefix) {
        Path tempDirectoryPath = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
        File[] files = tempDirectoryPath.toFile().listFiles();
        if (files != null) {
            Arrays.stream(files).filter(file -> file.getPath().contains(agilitestResourcesPrefix)).forEach(FileUtils::deleteFolder);
        }
    }

    public static File copyResource(String resName, Path dest) {
        String customTemplatesPath = "/reports/templates/";
        Path filePath = dest.resolve(resName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            InputStream is = ResourceContent.class.getResourceAsStream(customTemplatesPath + resName);
            BufferedInputStream in = new BufferedInputStream(is);
            File targetFile = dest.resolve(resName).toFile();
            try {
                int lengthRead;
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] buffer = new byte[1024];
                while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, lengthRead);
                    ((OutputStream)out).flush();
                }
                ((InputStream)in).close();
                is.close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                AtsLogger.printLog("not able to copy resource...");
            }
        }
        return filePath.toFile();
    }

    public static String getBase64LogoProperty(HtmlReportProject project, String outputFolderPath) {
        String logoPath = Project.REPORT_LOGO_URL;
        InputStream input = null;
        try {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream(logoPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (input == null) {
            try {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream("src/" + logoPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (input != null) {
            try {
                return "data:image/png;base64," + new String(Base64.getEncoder().encode(input.readAllBytes()));
            }
            catch (IOException e) {
                AtsLogger.printLog("cannot get project's report logo data");
            }
        }
        return project.getATS_LOGO();
    }

    public static List<Script> getScripts(String outputFolderPath) {
        List<Script> scripts = new ArrayList<Script>();
        try (BufferedReader br = new BufferedReader(new FileReader(outputFolderPath + File.separator + "ats-scripts.json"));){
            String line;
            ObjectMapper objectMapper = new ObjectMapper();
            JSONArray jsonArray = new JSONArray();
            while ((line = br.readLine()) != null) {
                JSONObject jsonObject = (JSONObject)objectMapper.readValue(line, JSONObject.class);
                jsonArray.add((Object)jsonObject);
            }
            scripts = (List)objectMapper.readValue(jsonArray.toString(), (TypeReference)new TypeReference<List<Script>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scripts;
    }

    public static boolean isFileSizeLessThan(File file, int sizeToCompareWithInMB) {
        return file.length() <= (long)sizeToCompareWithInMB * 1024L * 1024L;
    }
}

