/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;

public class JasperSummaryUtils {
    public static void generateSummaryPdf(Path outputFolderPath, String dataFileName) {
        JasperSummaryUtils.processJasperTemplates(outputFolderPath);
        JasperSummaryUtils.processSummaryPdf(outputFolderPath, dataFileName);
    }

    private static void processJasperTemplates(Path outputFolderPath) {
        Path outputJasperFolder = outputFolderPath.resolve("ats-jasper");
        try {
            Utils.deleteRecursive(outputJasperFolder.toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            Files.createDirectory(outputJasperFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtils.copyResource("suite.jrxml", outputJasperFolder);
        FileUtils.copyResource("test.jrxml", outputJasperFolder);
        FileUtils.copyResource("summary.jrxml", outputJasperFolder);
        try {
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("test.jrxml").toString(), (String)outputJasperFolder.resolve("test.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("suite.jrxml").toString(), (String)outputJasperFolder.resolve("suite.jasper").toString());
            JasperCompileManager.compileReportToFile((String)outputJasperFolder.resolve("summary.jrxml").toString(), (String)outputJasperFolder.resolve("summary.jasper").toString());
            AtsLogger.printLog("JASPER reports templates generated");
        }
        catch (JRException e) {
            AtsLogger.printLog("error generating jasper files -> " + e.getMessage());
        }
    }

    private static void processSummaryPdf(Path outputFolderPath, String dataFileName) {
        try {
            String reportFullName = outputFolderPath.resolve("summary.pdf").toString();
            Path outputJasperFolder = outputFolderPath.resolve("ats-jasper");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("workingDir", outputJasperFolder.toString());
            parameters.put("xmlSource", outputFolderPath.resolve(dataFileName).toString());
            parameters.put("xmlSourceRoot", "ats-report");
            String fileName = JasperFillManager.fillReportToFile((String)outputJasperFolder.resolve("summary.jasper").toString(), parameters);
            JasperExportManager.exportReportToPdfFile((String)fileName, (String)reportFullName);
            AtsLogger.printLog("PDF file -> " + reportFullName + " ... OK");
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

