/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.graphic.ImageTemplateMatchingSimple;
import com.ats.tools.Utils;
import java.util.List;
import java.util.function.Predicate;

public class TestElementImage
extends TestElement {
    public static final String ATS_X = "-ats-image-x";
    public static final String ATS_Y = "-ats-image-y";
    public static final String ATS_WIDTH = "-ats-image-width";
    public static final String ATS_HEIGHT = "-ats-image-height";

    public TestElementImage(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> predicate, SearchedElement searchElement) {
        super(script, channel, maxTry, predicate, searchElement);
    }

    @Override
    protected List<FoundElement> loadElements(SearchedElement searchedElement) {
        if (this.parent != null) {
            this.engine.mouseMoveToElement(this.parent.getFoundElement());
        }
        ImageTemplateMatchingSimple template = new ImageTemplateMatchingSimple(searchedElement.getImage());
        for (CalculatedProperty property : searchedElement.getCriterias()) {
            if (!"error".equals(property.getName())) continue;
            String value = property.getValue().getCalculated();
            if (value.endsWith("%")) {
                template.setPercentError(Utils.string2Double(value.replace("%", "").trim()));
                break;
            }
            template.setError(Utils.string2Int(value.trim()));
            break;
        }
        return this.engine.findElements(this.parent, template);
    }

    @Override
    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        FoundElement fe = this.getFoundElement();
        if (this.parent != null) {
            FoundElement parentElement = this.parent.getFoundElement();
            Double innerX = fe.getScreenX() - parentElement.getScreenX() + this.getFoundElement().getWidth() / 2.0 - parentElement.getWidth() / 2.0;
            Double innerY = fe.getScreenY() - parentElement.getScreenY() + this.getFoundElement().getHeight() / 2.0 - parentElement.getHeight() / 2.0;
            this.parent.over(status, position, false, innerX.intValue(), innerY.intValue());
        } else {
            TestBound bound = this.channel.getDimension();
            super.engineOver(status, position, desktopDragDrop, fe.getInnerX() + bound.getX().intValue(), fe.getInnerY() + bound.getY().intValue());
        }
    }

    @Override
    protected void mouseClick(ActionStatus status, MouseDirection position, int offsetX, int offsetY) {
        FoundElement fe = this.getFoundElement();
        if (this.parent != null) {
            FoundElement parentElement = this.parent.getFoundElement();
            Double innerX = fe.getScreenX() - parentElement.getScreenX() + this.getFoundElement().getWidth() / 2.0 - parentElement.getWidth() / 2.0;
            Double innerY = fe.getScreenY() - parentElement.getScreenY() + this.getFoundElement().getHeight() / 2.0 - parentElement.getHeight() / 2.0;
            this.engine.mouseClick(status, this.parent.getFoundElement(), position, innerX.intValue(), innerY.intValue());
            this.channel.actionTerminated(status);
        } else {
            TestBound bound = this.channel.getDimension();
            int cx = fe.getInnerX() + bound.getX().intValue();
            int cy = fe.getInnerY() + bound.getY().intValue();
            this.script.getLogger().sendInfo("click on image", cx + "x" + cy);
            super.mouseClick(status, position, cx, cy);
        }
    }

    @Override
    public void mouseWheel(int delta) {
    }

    @Override
    public void clearText(ActionStatus status, MouseDirection md) {
        this.engine.getSystemDriver().clearText();
    }

    @Override
    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        String enterText = this.channel.rootKeys(status, text);
        this.channel.actionTerminated(status);
        return enterText;
    }

    @Override
    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        MouseDirection md = new MouseDirection();
        this.mouseClick(status, md, 0, 0);
        return this.finalizeEnterText(status, text, md, script, waitChar);
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return String.valueOf(this.getCount());
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return String.valueOf(this.getIndex());
        }
        if ("-ats-table-data".equals(name)) {
            return null;
        }
        if (ATS_X.equals(name)) {
            return String.valueOf(this.getFoundElement().getBoundX().intValue());
        }
        if (ATS_Y.equals(name)) {
            return String.valueOf(this.getFoundElement().getBoundY().intValue());
        }
        if (ATS_WIDTH.equals(name)) {
            return String.valueOf(this.getFoundElement().getWidth().intValue());
        }
        if (ATS_HEIGHT.equals(name)) {
            return String.valueOf(this.getFoundElement().getHeight().intValue());
        }
        return "";
    }

    @Override
    public void drag(ActionStatus status, MouseDirection position, int offsetX, int offsetY, boolean offset) {
        super.drag(status, position, this.getFoundElement().getBoundX().intValue(), this.getFoundElement().getBoundY().intValue(), offset);
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes() {
        return this.getAttributes(true);
    }

    @Override
    public CalculatedProperty[] getAttributes(boolean reload) {
        return new CalculatedProperty[]{this.getAtsProperty(ATS_OCCURRENCES.toString()), this.getAtsProperty(ATS_OCCURRENCES_INDEX.toString()), new CalculatedProperty(ATS_X, String.valueOf(this.getFoundElement().getBoundX().intValue())), new CalculatedProperty(ATS_Y, String.valueOf(this.getFoundElement().getBoundY().intValue())), new CalculatedProperty(ATS_WIDTH, String.valueOf(this.getFoundElement().getWidth().intValue())), new CalculatedProperty(ATS_HEIGHT, String.valueOf(this.getFoundElement().getHeight().intValue()))};
    }

    @Override
    public Object executeScript(ActionStatus status, String script, boolean returnValue) {
        return null;
    }
}

