/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.generator.variables.CalculatedValue;
import com.ats.tools.Utils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BrowserArgumentsParser {
    private static final String INCOGNITO_OPTION = "incognito";
    private static final String PRIVATE_OPTION = "private";
    private static final String IN_PRIVATE_OPTION = "inprivate";
    private static final String HEADLESS_OPTION = "headless";
    private static final String LOAD_EXTENSION = "load-extension";
    private static final String PROFILE_OPTION = "profile";
    private static final String LANG_OPTION = "lang";
    private static final String MEDIA_ENCODER = "media-encoder";
    private static final String MAC_BRAVE_BROWSER_PATH = "/Applications/Brave Browser.app/Contents/MacOS/Brave Browser";
    private String userDataPath;
    private String binaryPath;
    private boolean incognito = false;
    private boolean headless = false;
    private String lang;
    private String[] moreOptions = null;
    private List<String> plugins = null;
    private File[] extensions;

    public BrowserArgumentsParser(IDriverInfo driverInfo, ArrayList<CalculatedValue> arguments, ApplicationProperties props, String browserName, String binary, SystemDriver systemDriver) {
        ArrayList<Object> args = new ArrayList<Object>();
        boolean firefoxLinux = false;
        boolean braveMacOs = false;
        if ("firefox".equals(browserName)) {
            if (binary == null && driverInfo.getApplicationPath() != null) {
                binary = driverInfo.getApplicationPath();
            }
            if (systemDriver.isLinux()) {
                firefoxLinux = true;
            }
            this.plugins = new LinkedList<String>(Arrays.asList(props.getPlugins()));
        } else if ("msedge".equals(browserName)) {
            args.add("edge-skip-compat-layer-relaunch");
        } else if ("brave".equals(browserName) && systemDriver.getOsName().toLowerCase().contains("mac")) {
            braveMacOs = true;
        }
        ArrayList<File> extensionFiles = new ArrayList<File>();
        for (CalculatedValue calculatedValue : arguments) {
            String arg = calculatedValue.getCalculated();
            if (arg.startsWith(PROFILE_OPTION)) {
                String profile = arg.replace(PROFILE_OPTION, "").replace("=", "").trim();
                this.userDataPath = ApplicationProperties.getUserDataPath(profile, browserName, systemDriver);
            } else if (arg.startsWith(LANG_OPTION)) {
                this.lang = arg.replace(LANG_OPTION, "").replace("=", "").trim();
            } else if (arg.contains(HEADLESS_OPTION)) {
                this.headless = true;
            } else if (arg.contains(INCOGNITO_OPTION) || arg.contains(PRIVATE_OPTION) || arg.contains(IN_PRIVATE_OPTION)) {
                this.incognito = true;
            } else if (arg.contains(LOAD_EXTENSION)) {
                String[] argData = arg.split("=");
                if (argData.length > 1) {
                    String filePath = argData[1];
                    File file = new File(filePath);
                    if (file.exists() && file.isDirectory()) {
                        args.add(arg);
                    } else {
                        try {
                            URI uri = new URI(argData[1]);
                            String scheme = uri.getScheme().toLowerCase();
                            file = "http".equals(scheme) || "https".equals(scheme) ? Utils.downloadFile(uri) : ("file".equals(scheme) ? new File(uri) : new File(argData[1]));
                            if (file != null && file.exists() && file.isFile()) {
                                extensionFiles.add(file);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                }
            } else {
                args.add(arg);
            }
            this.extensions = extensionFiles.toArray(new File[extensionFiles.size()]);
        }
        if (props.getLang() != null) {
            this.lang = props.getLang();
        }
        if (this.userDataPath == null) {
            this.userDataPath = firefoxLinux ? ApplicationProperties.getUserDataPath("default", browserName, systemDriver) : ApplicationProperties.getUserDataPath(props.getUserDataDir(), browserName, systemDriver);
        }
        this.binaryPath = binary == null ? driverInfo.getApplicationPath() : binary;
        if (braveMacOs) {
            this.binaryPath = MAC_BRAVE_BROWSER_PATH;
        }
        if (!this.headless && !systemDriver.isInteractive()) {
            this.headless = true;
        }
        if (props.getOptions() != null) {
            for (String s : props.getOptions()) {
                if (s.length() <= 0) continue;
                if (INCOGNITO_OPTION.equals(s) || PRIVATE_OPTION.equals(s)) {
                    this.incognito = true;
                    continue;
                }
                if (s.contains(HEADLESS_OPTION)) {
                    this.headless = true;
                    continue;
                }
                if (s.length() <= 0) continue;
                args.add(s);
            }
        }
        if (args.size() > 0) {
            for (String string : args) {
                if (!MEDIA_ENCODER.equals(string)) continue;
                this.removeMediaEncoder();
                this.plugins.add("media.eme.enabled=true");
                this.plugins.add("media.gmp-manager.updateEnabled=true");
                this.plugins.add("media.gmp.decoder.enabled=true");
                args.remove(MEDIA_ENCODER);
                break;
            }
            this.moreOptions = args.toArray(new String[args.size()]);
        }
        driverInfo.setHeadless(this.headless);
    }

    private void removeMediaEncoder() {
        Iterator<String> itr = this.plugins.iterator();
        while (itr.hasNext()) {
            String s = itr.next();
            if (!s.startsWith("media.")) continue;
            itr.remove();
        }
    }

    public Map<String, Object> getPlugins(boolean noMedia) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.plugins != null) {
            if (noMedia) {
                this.removeMediaEncoder();
            }
            for (String s : this.plugins) {
                String[] data = s.split("=");
                if (data.length > 1) {
                    map.put(data[0], this.castString(data[1]));
                    continue;
                }
                if (data.length <= 0) continue;
                map.put(data[0], null);
            }
        }
        return map;
    }

    private Object castString(String value) {
        if ("null".equalsIgnoreCase(value = value.trim())) {
            return null;
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception2) {
                return value;
            }
        }
    }

    public File[] getExtensions() {
        if (this.extensions == null) {
            return new File[0];
        }
        return this.extensions;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public String[] getMoreOptions() {
        if (this.moreOptions == null) {
            return new String[0];
        }
        return this.moreOptions;
    }

    public String getUserDataPath() {
        return this.userDataPath;
    }

    public boolean isIncognito() {
        return this.incognito;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public String getLang() {
        return this.lang;
    }
}

