/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class BaseValue {
    protected static final String startChar = "\u00bb";
    protected static final String endChar = "\u00ab";
    protected static final String separatorChar = "\u00ac";
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\u00bbV([^\u00ab]*)\u00ab", 2);
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("\u00bbP([^\u00ab]*)\u00ac([^\u00ab]*)\u00ab", 2);
    public static final Pattern ENV_PATTERN = Pattern.compile("\u00bbE([^\u00ab]*)\u00ac([^\u00ab]*)\u00ab", 2);
    public static final Pattern PROJECT_VARIABLE_PATTERN = Pattern.compile("\u00bbJ([^\u00ab]*)\u00ab", 2);
    protected String value;
    protected String codeValue;
    protected String replace = "";

    public BaseValue(Matcher m) {
        String data;
        this.replace = m.group(0);
        if (this.replace != null) {
            this.replace = StringEscapeUtils.escapeJava((String)this.replace);
        }
        this.value = data = StringEscapeUtils.escapeJava((String)m.group(1));
        this.codeValue = data;
    }

    public BaseValue(String value) {
        this.value = value;
        this.codeValue = value;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getNoComma() {
        return this.replace.replace(",", "\n");
    }

    public String getCode() {
        StringBuilder codeBuilder = new StringBuilder("(");
        codeBuilder.append(this.codeValue);
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    public String getType() {
        return "V";
    }

    public String getHashValue() {
        StringBuilder sb = new StringBuilder(startChar);
        sb.append(this.getType()).append(this.value).append(endChar);
        return sb.toString();
    }

    public String replace(String value) {
        return value.replace(this.getReplace(), this.getHashValue());
    }
}

