/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionAssertProperty
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "check-property";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private CalculatedProperty value;
    private String attributeValue;

    public ActionAssertProperty() {
    }

    public ActionAssertProperty(AtsScript script, ExecuteOptions options, int stopPolicy, String data, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray);
        this.setValue(new CalculatedProperty(script, data));
    }

    public ActionAssertProperty(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedProperty property) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setValue(property);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(", ").append(this.value.getJavaCode()).append(")");
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.addAll(this.value.getKeywords());
        if (this.attributeValue != null) {
            keywords.add(this.attributeValue);
        }
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().updateScreen();
            int leftTries = this.getActionMaxTry();
            int checkValue = this.checkProperty(this.value.getName());
            while (checkValue < 0 && leftTries > 0) {
                this.getCurrentChannel().tryAndWait(52, "assert property fail, wait and try again", this.getActionMaxTry(), --leftTries);
                checkValue = this.checkProperty(this.value.getName());
            }
            if (checkValue == -5) {
                ts.getRecorder().update(-5, this.status.endDuration(), this.value.getJsonPropertyData());
            } else {
                this.status.setCode(checkValue);
                ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.value.getJsonPropertyData(), Utils.escapeEmpty(this.attributeValue));
            }
        } else {
            ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.value.getJsonPropertyData(), "NO_DATA_AVAILABLE");
        }
    }

    private int checkProperty(String name) {
        this.attributeValue = this.getTestElement().getAttribute(this.status, name);
        if (this.attributeValue == null) {
            this.status.setError(-5, "attribute '" + name + "' not found", this.value.getName());
            return -5;
        }
        return this.value.checkProperty(this.status, this.attributeValue);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("property", this.value.getName());
        data.addProperty("value", this.attributeValue);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedProperty getValue() {
        return this.value;
    }

    public void setValue(CalculatedProperty value) {
        this.value = value;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".AssertProperty");
    }
}

