/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.models;

import com.ats.tools.Utils;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.TestSummary;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TestInfo {
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd 'at' HH:mm:ss";
    private String cpuCount;
    private String cpuSpeed;
    private String externalId;
    private String osInfo;
    private String testId;
    private String testName;
    private String totalMemory;
    private String description;
    private String author;
    private String prerequisite;
    private String started;
    private String startedFormatted;
    private String quality;
    private String durationChart;
    private String modifiedBy;
    private String modifiedAt;
    private String createdAt;
    private List<String> groups = new ArrayList<String>();
    private HtmlReportProject project;
    private TestSummary summary;

    public String toString() {
        return "TestRecord{cpuCount=" + this.cpuCount + ", cpuSpeed=" + this.cpuSpeed + ", externalId='" + this.externalId + "', osInfo='" + this.osInfo + "', testId='" + this.testId + "', testName='" + this.testName + "', totalMemory=" + this.totalMemory + ", description='" + this.description + "', author='" + this.author + "', prerequisite='" + this.prerequisite + "', started=" + this.started + ", startedFormatted='" + this.startedFormatted + "', quality=" + this.quality + ", groups=" + String.valueOf(this.groups) + ", project=" + String.valueOf(this.project) + ", summary=" + String.valueOf(this.summary) + "}";
    }

    public String getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(String cpuCount) {
        this.cpuCount = cpuCount;
    }

    public String getCpuSpeed() {
        return this.cpuSpeed;
    }

    public void setCpuSpeed(String cpuSpeed) {
        this.cpuSpeed = cpuSpeed;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getOsInfo() {
        return this.osInfo;
    }

    public void setOsInfo(String osInfo) {
        this.osInfo = osInfo;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(String totalMemory) {
        this.totalMemory = totalMemory;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String prerequisite) {
        this.prerequisite = prerequisite;
    }

    public String getStarted() {
        return this.started;
    }

    public void setStarted(String started) {
        this.started = started;
    }

    public String getStartedFormatted() {
        return this.startedFormatted;
    }

    public void setStartedFormatted(String startedFormatted) {
        this.startedFormatted = startedFormatted;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public HtmlReportProject getProject() {
        return this.project;
    }

    public void setProject(HtmlReportProject project) {
        this.project = project;
    }

    public TestSummary getSummary() {
        return this.summary;
    }

    public void setSummary(TestSummary summary) {
        this.summary = summary;
    }

    public String getDurationChart() {
        return this.durationChart;
    }

    public void setDurationChart(String durationChart) {
        this.durationChart = durationChart;
    }

    public String getFinishedFormated() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(Utils.string2Long(this.getStarted()) + Utils.string2Long(this.summary.getExecutionTime())), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
    }

    public String getModifiedBy() {
        String modifiedByUser = null;
        if (StringUtils.isNotEmpty((CharSequence)this.modifiedBy)) {
            String[] userNames = this.modifiedBy.split(":");
            modifiedByUser = userNames.length > 2 ? userNames[2] : userNames[1];
        }
        return modifiedByUser;
    }

    public String getSystemUser() {
        return this.modifiedBy.split(":").length > 1 ? this.modifiedBy.split(":")[1] : null;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedAt() {
        return this.modifiedAt == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(Utils.string2Long(this.modifiedAt)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getCreatedAt() {
        return this.createdAt == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(Utils.string2Long(this.createdAt)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }
}

