/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.archive.hbase;

import com.activequant.archive.IArchiveFactory;
import com.activequant.archive.IArchiveReader;
import com.activequant.archive.IArchiveWriter;
import com.activequant.archive.hbase.HBaseArchiveReader;
import com.activequant.archive.hbase.HBaseArchiveWriter;
import com.activequant.domainmodel.TimeFrame;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HBaseArchiveFactory
implements IArchiveFactory {
    private final Map<TimeFrame, IArchiveReader> readers = new HashMap<TimeFrame, IArchiveReader>();
    private final Map<TimeFrame, IArchiveWriter> writers = new HashMap<TimeFrame, IArchiveWriter>();
    private final String zookeeperHost;
    private final int zookeeperPort;

    public HBaseArchiveFactory(String zookeeperHost) {
        this.zookeeperHost = zookeeperHost;
        this.zookeeperPort = 2181;
    }

    public HBaseArchiveFactory(String zookeeperHost, int zookeeperPort) {
        this.zookeeperHost = zookeeperHost;
        this.zookeeperPort = zookeeperPort;
    }

    @Override
    public synchronized IArchiveReader getReader(TimeFrame tf) {
        if (this.readers.get((Object)tf) == null) {
            try {
                HBaseArchiveReader reader = new HBaseArchiveReader(this.zookeeperHost, this.zookeeperPort, tf);
                this.readers.put(tf, reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.readers.get((Object)tf);
    }

    @Override
    public synchronized IArchiveWriter getWriter(TimeFrame tf) {
        if (this.writers.get((Object)tf) == null) {
            try {
                HBaseArchiveWriter writer = new HBaseArchiveWriter(this.zookeeperHost, this.zookeeperPort, tf);
                this.writers.put(tf, writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.writers.get((Object)tf);
    }
}

