/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.archive.hbase;

import com.activequant.archive.IArchiveReader;
import com.activequant.archive.MultiValueTimeSeriesIterator;
import com.activequant.archive.TSContainer;
import com.activequant.archive.TimeSeriesIterator;
import com.activequant.archive.hbase.HBaseBase;
import com.activequant.domainmodel.TimeFrame;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.domainmodel.Tuple;
import com.activequant.utils.Date8Time6Parser;
import com.activequant.utils.UniqueTimeStampGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;

class HBaseArchiveReader
extends HBaseBase
implements IArchiveReader {
    private UniqueTimeStampGenerator timeStampGenerator = new UniqueTimeStampGenerator();
    private Date8Time6Parser d8t6p = new Date8Time6Parser();
    private Logger log = Logger.getLogger(HBaseArchiveReader.class);

    HBaseArchiveReader(String zookeeperHost, TimeFrame tf) throws IOException {
        super(zookeeperHost, 2181, "TSDATA_" + tf.toString());
    }

    HBaseArchiveReader(String zookeeperHost, int zookeeperPort, TimeFrame tf) throws IOException {
        super(zookeeperHost, zookeeperPort, "TSDATA_" + tf.toString());
    }

    @Deprecated
    HBaseArchiveReader(TimeFrame tf) throws IOException {
        super("TSDATA_" + tf.toString());
    }

    @Override
    public TSContainer getTimeSeries(String instrumentId, String value, TimeStamp startTimeStamp) throws Exception {
        return this.getTimeSeries(instrumentId, value, startTimeStamp, this.timeStampGenerator.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSContainer getTimeSeries(String instrumentId, String value, TimeStamp startTimeStamp, TimeStamp stopTimeStamp) throws Exception {
        ResultScanner scanner = this.getScanner(instrumentId, startTimeStamp, stopTimeStamp);
        ArrayList<TimeStamp> timeStamps = new ArrayList<TimeStamp>();
        ArrayList<Double> values = new ArrayList<Double>();
        try {
            Result rr = scanner.next();
            while (rr != null) {
                if (rr.containsColumn("numbers".getBytes(), value.getBytes())) {
                    byte[] valB = rr.getValue("numbers".getBytes(), value.getBytes());
                    byte[] tsB = rr.getValue("numbers".getBytes(), "ts".getBytes());
                    Double val = Bytes.toDouble((byte[])valB);
                    Long ts = Bytes.toLong((byte[])tsB);
                    timeStamps.add(new TimeStamp(ts));
                    values.add(val);
                }
                rr = scanner.next();
            }
        }
        finally {
            scanner.close();
        }
        TSContainer ret = new TSContainer(timeStamps.toArray(new TimeStamp[0]), values.toArray(new Double[0]));
        return ret;
    }

    private ResultScanner getScanner(String instrumentId, TimeStamp startTimeStamp, TimeStamp stopTimeStamp) throws IOException {
        String startKey = instrumentId + "_" + this.padded(startTimeStamp.toString());
        String stopKey = instrumentId + "_" + this.padded(stopTimeStamp.toString());
        Scan s = new Scan(startKey.getBytes(), stopKey.getBytes());
        s.setMaxVersions(1);
        ResultScanner scanner = this.htable.getScanner(s);
        return scanner;
    }

    @Override
    public TimeSeriesIterator getTimeSeriesStream(String instrumentId, final String key, TimeStamp startTimeStamp, TimeStamp stopTimeStamp) throws Exception {
        final ResultScanner scanner = this.getScanner(instrumentId, startTimeStamp, stopTimeStamp);
        return new TimeSeriesIterator(){
            Iterator<Result> resultIterator;
            final Result rr;
            {
                this.resultIterator = scanner.iterator();
                this.rr = null;
            }

            @Override
            public boolean hasNext() {
                return this.resultIterator.hasNext();
            }

            @Override
            public Tuple<TimeStamp, Double> next() {
                Result rr = this.resultIterator.next();
                if (rr != null) {
                    if (rr.containsColumn("numbers".getBytes(), key.getBytes())) {
                        byte[] valB = rr.getValue("numbers".getBytes(), key.getBytes());
                        byte[] tsB = rr.getValue("numbers".getBytes(), "ts".getBytes());
                        Double val = Bytes.toDouble((byte[])valB);
                        Long ts = Bytes.toLong((byte[])tsB);
                        return new Tuple<TimeStamp, Double>(new TimeStamp(ts), val);
                    }
                    return null;
                }
                scanner.close();
                return null;
            }
        };
    }

    @Override
    public MultiValueTimeSeriesIterator getMultiValueStream(String streamId, TimeStamp startTimeStamp, TimeStamp stopTimeStamp) throws Exception {
        final ResultScanner scanner = this.getScanner(streamId, startTimeStamp, stopTimeStamp);
        return new MultiValueTimeSeriesIterator(){
            Iterator<Result> resultIterator;
            Result rr;
            {
                this.resultIterator = scanner.iterator();
                this.rr = null;
            }

            @Override
            public boolean hasNext() {
                return this.resultIterator.hasNext();
            }

            @Override
            public Tuple<TimeStamp, Map<String, Double>> next() {
                this.rr = this.resultIterator.next();
                Tuple<TimeStamp, Map<String, Double>> resultTuple = new Tuple<TimeStamp, Map<String, Double>>();
                HashMap<String, Double> resultMap = new HashMap<String, Double>();
                resultTuple.setB(resultMap);
                if (this.rr != null) {
                    NavigableMap valueMap = this.rr.getNoVersionMap();
                    byte[] tsB = this.rr.getValue("numbers".getBytes(), "ts".getBytes());
                    Long ts = Bytes.toLong((byte[])tsB);
                    TimeStamp timeStamp = new TimeStamp(ts);
                    resultTuple.setA(timeStamp);
                    NavigableMap numbersMap = (NavigableMap)valueMap.get("numbers".getBytes());
                    for (Map.Entry entry : numbersMap.entrySet()) {
                        String key = Bytes.toString((byte[])((byte[])entry.getKey()));
                        Double value = Bytes.toDouble((byte[])((byte[])entry.getValue()));
                        resultMap.put(key, value);
                    }
                } else {
                    scanner.close();
                }
                return resultTuple;
            }
        };
    }
}

