/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.archive.hbase;

import com.activequant.archive.IArchiveWriter;
import com.activequant.archive.hbase.HBaseBase;
import com.activequant.domainmodel.TimeFrame;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.domainmodel.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

class HBaseArchiveWriter
extends HBaseBase
implements IArchiveWriter {
    private List<Put> puts = new ArrayList<Put>();

    HBaseArchiveWriter(String zookeeperHost, TimeFrame tf) throws IOException {
        super(zookeeperHost, 2181, "TSDATA_" + tf.toString());
    }

    HBaseArchiveWriter(String zookeeperHost, int zookeeperPort, TimeFrame tf) throws IOException {
        super(zookeeperHost, zookeeperPort, "TSDATA_" + tf.toString());
    }

    @Deprecated
    HBaseArchiveWriter(TimeFrame tf) throws IOException {
        super("TSDATA_" + tf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        List<Put> list = this.puts;
        synchronized (list) {
            this.htable.put(this.puts);
            this.puts.clear();
            this.htable.flushCommits();
        }
    }

    @Override
    public void write(String instrumentId, TimeStamp timeStamp, Tuple<String, Double> ... value) throws IOException {
        for (Tuple<String, Double> t : value) {
            this.write(instrumentId, timeStamp, t.getA(), t.getB());
        }
    }

    @Override
    public void write(String instrumentId, TimeStamp timeStamp, String[] keys, Double[] values) {
        assert (values != null);
        assert (keys != null);
        assert (keys.length == values.length);
        for (int i = 0; i < keys.length; ++i) {
            this.write(instrumentId, timeStamp, keys[i], values[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String instrumentId, TimeStamp timeStamp, String key, Double value) {
        assert (key != null);
        assert (value != null);
        String rowKey = instrumentId + "_" + this.padded(timeStamp.toString());
        Put p = new Put(rowKey.getBytes());
        p.add("numbers".getBytes(), key.getBytes(), Bytes.toBytes((double)value));
        p.add("numbers".getBytes(), "ts".getBytes(), Bytes.toBytes((long)timeStamp.getNanoseconds()));
        List<Put> list = this.puts;
        synchronized (list) {
            this.puts.add(p);
        }
    }
}

