/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.archive.hbase;

import com.activequant.utils.StringUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.log4j.Logger;

class HBaseBase {
    private Logger log = Logger.getLogger(HBaseBase.class);
    protected HTable htable;

    HBaseBase(String zookeeperQuorumHost, String tableName) throws IOException {
        this(zookeeperQuorumHost, 2181, tableName);
    }

    HBaseBase(String zookeeperQuorumHost, int zookeeperPort, String tableName) throws IOException {
        Configuration config = HBaseConfiguration.create();
        config.set("hbase.zookeeper.quorum", zookeeperQuorumHost + ":" + zookeeperPort);
        HBaseAdmin admin = new HBaseAdmin(config);
        if (!admin.tableExists(tableName.getBytes())) {
            this.log.info((Object)"HTable doesn't exist. Creating it.");
            HTableDescriptor desc = new HTableDescriptor(tableName.getBytes());
            HColumnDescriptor col1 = new HColumnDescriptor("numbers".getBytes());
            desc.addFamily(col1);
            admin.createTable(desc);
            boolean avail = admin.isTableAvailable(tableName.getBytes());
            this.log.info((Object)("HTable is available: " + avail));
        }
        this.htable = new HTable(config, tableName.getBytes());
        this.htable.setAutoFlush(false);
        this.htable.setScannerCaching(1000000);
    }

    public String padded(String key) {
        int refLength = "1235526680000000000".length();
        if (key.length() < refLength) {
            String padding = StringUtils.repeat('0', refLength - key.length());
            key = padding + key;
        }
        return key;
    }

    @Deprecated
    HBaseBase(String tableName) throws IOException {
        this("localhost", tableName);
    }
}

