/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.backtesting;

import com.activequant.archive.IArchiveReader;
import com.activequant.archive.MultiValueTimeSeriesIterator;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.domainmodel.Tuple;
import com.activequant.tools.streaming.BBOEvent;
import com.activequant.tools.streaming.MarketDataEvent;
import com.activequant.tools.streaming.StreamEventIterator;
import java.util.Map;

public class ArchiveStreamToMarketDataIterator
extends StreamEventIterator<MarketDataEvent> {
    private String mdId;
    private MultiValueTimeSeriesIterator streamIterator;
    private Double bid;
    private Double ask;
    private Double bidQ;
    private Double askQ;

    public ArchiveStreamToMarketDataIterator(String mdiId, TimeStamp startTime, TimeStamp endTime, IArchiveReader archiveReader) throws Exception {
        this.mdId = mdiId;
        this.streamIterator = archiveReader.getMultiValueStream(mdiId, startTime, endTime);
    }

    @Override
    public boolean hasNext() {
        return this.streamIterator.hasNext();
    }

    @Override
    public MarketDataEvent next() {
        Tuple valueMap = (Tuple)this.streamIterator.next();
        if (((Map)valueMap.getB()).containsKey("BID")) {
            this.bid = (Double)((Map)valueMap.getB()).get("BID");
        }
        if (((Map)valueMap.getB()).containsKey("ASK")) {
            this.ask = (Double)((Map)valueMap.getB()).get("ASK");
        }
        if (((Map)valueMap.getB()).containsKey("BIDQUANTITY")) {
            this.bidQ = (Double)((Map)valueMap.getB()).get("BIDQUANTITY");
        }
        if (((Map)valueMap.getB()).containsKey("ASKQUANTITY")) {
            this.askQ = (Double)((Map)valueMap.getB()).get("ASKQUANTITY");
        }
        return new BBOEvent(this.mdId, this.mdId, (TimeStamp)valueMap.getA(), this.bid, this.bidQ, this.ask, this.askQ);
    }
}

