/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.backtesting;

import com.activequant.archive.IArchiveFactory;
import com.activequant.backtesting.FastStreamer;
import com.activequant.dao.IDaoFactory;
import com.activequant.tools.streaming.MarketDataEvent;
import com.activequant.tools.streaming.ReferenceDataEvent;
import com.activequant.tools.streaming.StreamEvent;
import com.activequant.tools.streaming.StreamEventIterator;
import com.activequant.tools.streaming.TradingDataEvent;
import com.activequant.trading.ITradingSystem;
import com.activequant.trading.TradingSystemEnvironment;
import com.activequant.trading.virtual.IExchange;
import com.activequant.transport.ETransportType;
import com.activequant.transport.ITransportFactory;
import com.activequant.utils.TimeMeasurement;

public class Backtester {
    private IExchange exchange;
    private ITransportFactory transportFactory;
    private StreamEventIterator[] streamIters;
    private ITradingSystem[] tradingSystems;

    public Backtester(IArchiveFactory factory, ITransportFactory transportFactory, IDaoFactory daoFactory, IExchange exchange, ITradingSystem[] tradingSystems, StreamEventIterator[] streamIters) throws Exception {
        this.exchange = exchange;
        this.streamIters = streamIters;
        this.transportFactory = transportFactory;
        this.streamIters = streamIters;
        this.tradingSystems = tradingSystems;
        TradingSystemEnvironment env = new TradingSystemEnvironment();
        env.setArchiveFactory(factory);
        env.setDaoFactory(daoFactory);
        env.setExchange(exchange);
        env.setTransportFactory(transportFactory);
        for (ITradingSystem s : tradingSystems) {
            s.environment(env);
        }
        for (ITradingSystem s : tradingSystems) {
            s.initialize();
        }
    }

    public void execute() throws Exception {
        FastStreamer fs = new FastStreamer(this.streamIters);
        TimeMeasurement.start("BACKTEST");
        for (ITradingSystem s : this.tradingSystems) {
            s.start();
        }
        long eventCount = 0L;
        while (fs.moreDataInPipe()) {
            StreamEvent se = fs.getOneFromPipes();
            ETransportType transportType = se.getEventType();
            if (transportType.equals((Object)ETransportType.TIME)) {
                this.transportFactory.getPublisher(transportType.toString()).send(se);
            } else if (transportType.equals((Object)ETransportType.MARKET_DATA)) {
                MarketDataEvent mde = (MarketDataEvent)se;
                this.transportFactory.getPublisher(transportType, mde.getMdiId()).send(se);
                this.exchange.processStreamEvent(se);
            } else if (transportType.equals((Object)ETransportType.REF_DATA)) {
                ReferenceDataEvent rde = (ReferenceDataEvent)se;
                this.transportFactory.getPublisher(transportType, rde.getInstrument()).send(se);
            } else if (transportType.equals((Object)ETransportType.TRAD_DATA)) {
                TradingDataEvent tde = (TradingDataEvent)se;
                this.transportFactory.getPublisher(transportType, tde.getTradInst()).send(se);
                this.exchange.processStreamEvent(se);
            }
            ++eventCount;
        }
        for (ITradingSystem s : this.tradingSystems) {
            s.stop();
        }
        TimeMeasurement.stop("BACKTEST");
        long difference = TimeMeasurement.getRuntime("BACKTEST");
        System.out.println("Replayed " + eventCount + " events in " + difference + "ms. That's " + (double)eventCount / (double)difference + " events/ms");
    }
}

