/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.backtesting;

import com.activequant.tools.streaming.StreamEvent;
import com.activequant.tools.streaming.StreamEventIterator;
import java.util.PriorityQueue;

public class FastStreamer {
    private PriorityQueue<FastStreamEventContainer> fastQueue = new PriorityQueue();
    private final StreamEventIterator<StreamEvent>[] iterators;

    public FastStreamer(StreamEventIterator<StreamEvent>[] it) {
        this.iterators = it;
        for (int i = 0; i < it.length; ++i) {
            if (!it[i].hasNext()) continue;
            StreamEvent payload = (StreamEvent)it[i].next();
            FastStreamEventContainer fs = new FastStreamEventContainer(i);
            fs.streamEvent = payload;
            this.fastQueue.add(fs);
        }
    }

    public StreamEvent getOneFromPipes() {
        StreamEvent ret = null;
        if (!this.fastQueue.isEmpty()) {
            FastStreamEventContainer event = this.fastQueue.poll();
            if (event == null) {
                return ret;
            }
            ret = event.streamEvent;
            if (this.iterators[event.internalStreamId].hasNext()) {
                StreamEvent payload = (StreamEvent)this.iterators[event.internalStreamId].next();
                event.streamEvent = payload;
                this.fastQueue.add(event);
            }
        }
        return ret;
    }

    public boolean moreDataInPipe() {
        for (StreamEventIterator<StreamEvent> it : this.iterators) {
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    class FastStreamEventContainer
    implements Comparable<FastStreamEventContainer> {
        private final int internalStreamId;
        private StreamEvent streamEvent;

        FastStreamEventContainer(int streamId) {
            this.internalStreamId = streamId;
        }

        @Override
        public int compareTo(FastStreamEventContainer other) {
            if (this.streamEvent == null || other.streamEvent == null) {
                return -1;
            }
            return this.streamEvent.getTimeStamp().compareTo(other.streamEvent.getTimeStamp());
        }
    }
}

