/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.backtesting;

import com.activequant.domainmodel.TimeStamp;
import com.activequant.tools.streaming.BBOEvent;
import com.activequant.tools.streaming.MarketDataEvent;
import com.activequant.tools.streaming.StreamEventIterator;

public class RandomMarketDataIterator
extends StreamEventIterator<MarketDataEvent> {
    private long endTime;
    private long currentTime;
    private final long step;
    private String tradId;
    private String mdId;

    public RandomMarketDataIterator(String tradId, String mdiId, TimeStamp startTime, TimeStamp endTime, long stepWidthInNanoS) {
        this.step = stepWidthInNanoS;
        this.currentTime = startTime.getNanoseconds() - this.step;
        this.endTime = endTime.getNanoseconds();
        this.mdId = mdiId;
        this.tradId = tradId;
    }

    @Override
    public boolean hasNext() {
        return this.currentTime < this.endTime;
    }

    @Override
    public MarketDataEvent next() {
        this.currentTime += this.step;
        BBOEvent bbo = new BBOEvent(this.mdId, this.tradId, new TimeStamp(this.currentTime), Math.random(), Math.random(), Math.random(), Math.random());
        return bbo;
    }
}

