/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.backtesting;

import com.activequant.archive.TimeSeriesIterator;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.domainmodel.Tuple;
import java.util.PriorityQueue;

public class StreamMerger {
    private PriorityQueue<FastStreamEventContainer> fastQueue = new PriorityQueue();
    private final TimeSeriesIterator[] iterators;

    public StreamMerger(TimeSeriesIterator[] it) {
        this.iterators = it;
        for (int i = 0; i < it.length; ++i) {
            if (!it[i].hasNext()) continue;
            Tuple payload = (Tuple)it[i].next();
            if (payload == null || payload.getA() == null || payload.getB() == null) break;
            FastStreamEventContainer fs = new FastStreamEventContainer(i, payload);
            this.fastQueue.add(fs);
        }
    }

    public FastStreamEventContainer getOneFromPipes() {
        FastStreamEventContainer event = null;
        if (!this.fastQueue.isEmpty()) {
            event = this.fastQueue.poll();
            if (event == null) {
                return event;
            }
            if (this.iterators[event.internalStreamId].hasNext()) {
                Tuple payload = (Tuple)this.iterators[event.internalStreamId].next();
                if (payload == null) {
                    return null;
                }
                if (payload.getA() == null || payload.getB() == null) {
                    return null;
                }
                event.streamEvent = payload;
                this.fastQueue.add(event);
            }
        }
        return event;
    }

    public boolean moreDataInPipe() {
        for (TimeSeriesIterator it : this.iterators) {
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    class FastStreamEventContainer
    implements Comparable<FastStreamEventContainer> {
        public final int internalStreamId;
        public Tuple<TimeStamp, Double> streamEvent;

        FastStreamEventContainer(int streamId, Tuple<TimeStamp, Double> streamEvent) {
            this.internalStreamId = streamId;
            this.streamEvent = streamEvent;
        }

        @Override
        public int compareTo(FastStreamEventContainer other) {
            if (this.streamEvent == null || other.streamEvent == null) {
                return -1;
            }
            return this.streamEvent.getA().compareTo(other.streamEvent.getA());
        }
    }
}

