/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.dao.mybatis;

import com.activequant.dao.mybatis.mapper.GenericRowMapper;
import com.activequant.domainmodel.GenericRow;
import com.activequant.domainmodel.PersistentEntity;
import com.activequant.domainmodel.TimeStamp;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericMapperDao<T extends PersistentEntity> {
    private Logger log = Logger.getLogger(GenericMapperDao.class);
    protected GenericRowMapper mapper;
    private String tableName;
    private Class<? extends PersistentEntity> clazz;

    public GenericMapperDao(GenericRowMapper mapper, Class<? extends PersistentEntity> clazz, String table) {
        this.log.info((Object)("Initializing GenericDao for table " + table));
        this.mapper = mapper;
        this.clazz = clazz;
        try {
            mapper.init(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)("Message while creating table, can be ignored on consecutive runs: " + ex.getStackTrace()[0]));
        }
        this.tableName = table;
        try {
            mapper.genIndex1(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex2(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex3(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex4(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex5(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex6(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex7(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genIndex8(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
        try {
            mapper.genKey9(table);
        }
        catch (Exception ex) {
            this.log.debug((Object)"Index already exists.");
        }
    }

    public T load(String primaryKey) {
        List<GenericRow> rows = this.mapper.load(this.tableName, primaryKey);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GenericRow row : rows) {
            String fieldName = row.getFieldName();
            if (row.getDoubleVal() != null) {
                map.put(fieldName, row.getDoubleVal());
                continue;
            }
            if (row.getLongVal() != null) {
                map.put(fieldName, row.getLongVal());
                continue;
            }
            if (row.getStringVal() == null) continue;
            map.put(fieldName, row.getStringVal());
        }
        String className = (String)map.get("ClassName".toUpperCase());
        if (className == null) {
            return null;
        }
        PersistentEntity ret = null;
        try {
            Class<?> clazz = Class.forName(className);
            ret = (PersistentEntity)clazz.newInstance();
            ret.initFromMap(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)ret;
    }

    public T[] loadAll() {
        List<String> iids = this.mapper.loadKeyList(this.tableName);
        PersistentEntity[] ret = (PersistentEntity[])Array.newInstance(this.clazz, iids.size());
        for (int i = 0; i < iids.size(); ++i) {
            ret[i] = this.load(iids.get(i));
        }
        return ret;
    }

    public synchronized void delete(T t) {
        this.mapper.delete(this.tableName, ((PersistentEntity)t).getId());
    }

    public synchronized void update(T t) {
        this.delete(t);
        this.create(t);
    }

    public String[] findIDsWhereCreationDateBetween(TimeStamp startTs, TimeStamp endTs) {
        List<String> ids = this.mapper.findIDsBetween(this.tableName, startTs.getMilliseconds(), endTs.getMilliseconds());
        return ids.toArray(new String[0]);
    }

    public String[] loadIDs() {
        List<String> iids = this.mapper.loadKeyList(this.tableName);
        return iids.toArray(new String[0]);
    }

    private GenericRow genRow(long createdTimeStamp, String id, String key, Object value) {
        GenericRow gr = null;
        if (value instanceof Double) {
            gr = new GenericRow(createdTimeStamp, id, key, null, (Double)value, null);
        } else if (value instanceof String) {
            gr = new GenericRow(createdTimeStamp, id, key, null, null, (String)value);
        } else if (value instanceof Integer) {
            gr = new GenericRow(createdTimeStamp, id, key, (Long)value, null, null);
        } else if (value instanceof Long) {
            gr = new GenericRow(createdTimeStamp, id, key, (Long)value, null, null);
        }
        return gr;
    }

    private List<GenericRow> createGenRows(T t) {
        ArrayList<GenericRow> ret = new ArrayList<GenericRow>();
        Map<String, Object> map = ((PersistentEntity)t).propertyMap();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            boolean added = false;
            String key = it.next();
            Object value = map.get(key);
            if (value == null) continue;
            GenericRow gr = null;
            long createdTimeStamp = System.currentTimeMillis();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                int totalLength = array.length;
                for (int i = 0; i < totalLength; ++i) {
                    String fieldName = "[" + key + ";" + i + ";" + totalLength;
                    GenericRow temp = this.genRow(createdTimeStamp, ((PersistentEntity)t).getId(), fieldName, array[i]);
                    ret.add(temp);
                    added = true;
                }
            } else {
                gr = this.genRow(createdTimeStamp, ((PersistentEntity)t).getId(), key, value);
            }
            if (gr != null) {
                ret.add(gr);
                continue;
            }
            if (added) continue;
            this.log.warn((Object)("NO VALUE CONVERTER FOR VALUE: " + key + "/ " + value));
        }
        return ret;
    }

    public void create(T t) {
        List<GenericRow> rows = this.createGenRows(t);
        for (GenericRow row : rows) {
            this.mapper.insert(this.tableName, row);
        }
    }

    public String[] findIDs(String key, String sValue) {
        List<String> ret = this.mapper.findByString(this.tableName, key, sValue);
        return ret.toArray(new String[0]);
    }

    public String[] findIDsWhereLongValGreater(String fieldName, long sValue) {
        List<String> ret = this.mapper.findIDsWhereLongValGreater(this.tableName, fieldName, sValue);
        return ret.toArray(new String[0]);
    }

    public String[] findIDs(String key, Double dValue) {
        List<String> ret = this.mapper.findByDouble(this.tableName, key, dValue);
        return ret.toArray(new String[0]);
    }

    public String[] findIDs(String key, Long lValue) {
        List<String> ret = this.mapper.findByLong(this.tableName, key, lValue);
        return ret.toArray(new String[0]);
    }

    public String[] findIDs(int startIndex, int endIndex) {
        List<String> ret = this.mapper.findIDs(this.tableName, startIndex, endIndex);
        return ret.toArray(new String[0]);
    }

    public String[] findIDsLike(String idsLikeString, int resultAmount) {
        List<String> ret = this.mapper.findIdsLike(this.tableName, idsLikeString, resultAmount);
        return ret.toArray(new String[0]);
    }

    public int count() {
        return this.mapper.count(this.tableName);
    }

    public int countForAttributeValue(String key, String value) {
        return this.mapper.countForStringValue(this.tableName, key, value);
    }

    public int countForAttributeValue(String key, Double value) {
        return this.mapper.countForDoubleValue(this.tableName, key, value);
    }

    public int countForAttributeValue(String key, Long value) {
        return this.mapper.countForLongValue(this.tableName, key, value);
    }

    public String[] selectDistinctStringVal(String val) {
        List<String> ret = this.mapper.selectDistinctStringVal(this.tableName, val);
        return ret.toArray(new String[0]);
    }

    public Long[] selectDistinctLongVal(String val) {
        List<Long> ret = this.mapper.selectDistinctLongVal(this.tableName, val);
        return ret.toArray(new Long[0]);
    }

    public Double[] selectDistinctDoubleVal(String val) {
        List<Double> ret = this.mapper.selectDistinctDoubleVal(this.tableName, val);
        return ret.toArray(new Double[0]);
    }
}

