/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.dao.mybatis;

import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.dao.mybatis.GenericMapperDao;
import com.activequant.dao.mybatis.mapper.GenericRowMapper;
import com.activequant.domainmodel.Instrument;
import com.activequant.domainmodel.MarketDataInstrument;
import java.util.ArrayList;
import java.util.List;

public class MarketDataInstrumentDao
extends GenericMapperDao<MarketDataInstrument>
implements IMarketDataInstrumentDao {
    private static final String tableName = "MarketDataInstrument";

    public MarketDataInstrumentDao(GenericRowMapper mapper) {
        super(mapper, MarketDataInstrument.class, tableName);
    }

    @Override
    public MarketDataInstrument[] findFor(Instrument instrument) {
        List<String> ids = this.mapper.findByString(tableName, "INSTRUMENTID", instrument.getId());
        ArrayList mdis = new ArrayList();
        for (String id : ids) {
            mdis.add(this.load(id));
        }
        return mdis.toArray(new MarketDataInstrument[0]);
    }

    @Override
    public MarketDataInstrument[] findForProvider(String providerId) {
        List<String> ids = this.mapper.findByString(tableName, "mdProvider".toUpperCase(), providerId);
        ArrayList mdis = new ArrayList();
        for (String id : ids) {
            mdis.add(this.load(id));
        }
        return mdis.toArray(new MarketDataInstrument[0]);
    }

    @Override
    public MarketDataInstrument findByProvId(String providerId, String provSpecInstId) {
        List<String> insts = this.mapper.findBy2StringVals(tableName, "MdProvider".toUpperCase(), providerId, "ProviderSpecificId".toUpperCase(), provSpecInstId);
        if (insts.size() > 1) {
            throw new RuntimeException("Ambigous! " + providerId + "/" + provSpecInstId);
        }
        if (insts.size() == 0) {
            return null;
        }
        String id = insts.get(0);
        MarketDataInstrument mdi = (MarketDataInstrument)this.load(id);
        return mdi;
    }

    @Override
    public int countForProvider(String providerId) {
        return this.countForAttributeValue("MDPROVIDER", providerId);
    }

    @Override
    public MarketDataInstrument[] findForProvider(String providerId, int startIndex, int maxAmount) {
        List<String> ids = this.mapper.findByString(tableName, "mdProvider".toUpperCase(), providerId);
        ArrayList mdis = new ArrayList();
        for (int i = startIndex; i < startIndex + maxAmount; ++i) {
            if (ids.size() <= i) continue;
            mdis.add(this.load(ids.get(i)));
        }
        return mdis.toArray(new MarketDataInstrument[0]);
    }

    @Override
    public MarketDataInstrument[] findLike(String providerId, String provSpecInstId) {
        List<String> ids = this.mapper.findByString(tableName, "mdProvider".toUpperCase(), providerId);
        ArrayList<MarketDataInstrument> mdis = new ArrayList<MarketDataInstrument>();
        for (int i = 0; i < ids.size(); ++i) {
            MarketDataInstrument mdi = (MarketDataInstrument)this.load(ids.get(i));
            if (!mdi.getProviderSpecificId().startsWith(provSpecInstId)) continue;
            mdis.add(mdi);
        }
        return mdis.toArray(new MarketDataInstrument[0]);
    }

    @Override
    public MarketDataInstrument findFor(String providerId, Instrument instrument) {
        List<String> insts = this.mapper.findBy2StringVals(tableName, "MdProvider".toUpperCase(), providerId, "instrumentId".toUpperCase(), instrument.getId());
        if (insts.size() > 1) {
            throw new RuntimeException("Ambigous!" + providerId + "/" + instrument.getId());
        }
        if (insts.size() == 0) {
            return null;
        }
        String id = insts.get(0);
        MarketDataInstrument mdi = (MarketDataInstrument)this.load(id);
        return mdi;
    }

    @Override
    public String[] getProviders() {
        return super.selectDistinctStringVal("MDPROVIDER");
    }
}

