/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.dao.mybatis.mapper;

import com.activequant.domainmodel.GenericRow;
import java.util.List;
import org.apache.ibatis.annotations.CacheNamespace;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.springframework.transaction.annotation.Transactional;

@CacheNamespace(size=100000, flushInterval=900000L)
public interface GenericRowMapper {
    @Select(value={"create table ${table} (created bigint not null, keyVal varchar(200) not null, fieldName varchar(200) not null, doubleVal double, longVal bigint, stringVal varchar(200))"})
    public void init(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i1 on ${table} (keyVal, fieldName)"})
    public void genIndex1(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i2 on ${table} (keyVal)"})
    public void genIndex2(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i3 on ${table} (keyVal, fieldName, doubleVal)"})
    public void genIndex3(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i4 on ${table} (keyVal, fieldName, stringVal)"})
    public void genIndex4(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i5 on ${table} (keyVal, fieldName, longVal)"})
    public void genIndex5(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i6 on ${table} (fieldName, longVal)"})
    public void genIndex6(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i7 on ${table} (fieldName, doubleVal)"})
    public void genIndex7(@Param(value="table") String var1);

    @Select(value={"CREATE INDEX i8 on ${table} (fieldName, stringVal)"})
    public void genIndex8(@Param(value="table") String var1);

    @Select(value={"ALTER TABLE ${table} ADD PRIMARY KEY (fieldName, keyVal)"})
    public void genKey9(@Param(value="table") String var1);

    @Select(value={"select * from ${table} where keyVal = #{keyValue} order by fieldName ASC"})
    @Results(value={@Result(property="created", column="created"), @Result(property="keyVal", column="keyVal"), @Result(property="fieldName", column="fieldName"), @Result(property="doubleVal", column="doubleVal"), @Result(property="longVal", column="longVal"), @Result(property="stringVal", column="stringVal")})
    public List<GenericRow> load(@Param(value="table") String var1, @Param(value="keyValue") String var2);

    @Transactional
    @Insert(value={"insert into ${table} values (#{row.created}, #{row.keyVal},#{row.fieldName},#{row.doubleVal},#{row.longVal},#{row.stringVal})"})
    @Options(flushCache=true)
    public void insert(@Param(value="table") String var1, @Param(value="row") GenericRow var2);

    @Select(value={"SELECT distinct(keyVal) from ${table}"})
    public List<String> loadKeyList(@Param(value="table") String var1);

    @Select(value={"SELECT keyVal from ${table} where fieldName=#{fieldName} and stringVal=#{val}"})
    public List<String> findByString(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") String var3);

    @Select(value={"SELECT keyVal from ${table} where fieldName=#{fieldName} and longVal=#{val}"})
    public List<String> findByLong(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") Long var3);

    @Select(value={"SELECT keyVal from ${table} where fieldName=#{fieldName} and doubleVal=#{val}"})
    public List<String> findByDouble(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") Double var3);

    @Delete(value={"DELETE FROM ${table} where keyVal=#{keyVal}"})
    public void delete(@Param(value="table") String var1, @Param(value="keyVal") String var2);

    @Select(value={"select distinct(A.keyVal) from ${table} A, ${table} B where (A.fieldName=#{fieldName1} and A.stringVal=#{val1}) and  (B.fieldName=#{fieldName2} and B.stringVal = #{val2}) and A.keyVal = B.keyVal"})
    public List<String> findBy2StringVals(@Param(value="table") String var1, @Param(value="fieldName1") String var2, @Param(value="val1") String var3, @Param(value="fieldName2") String var4, @Param(value="val2") String var5);

    @Select(value={"SELECT keyVal from ${table} where fieldName=#{fieldName} and longVal>=#{val}"})
    public List<String> findIDsWhereLongValGreater(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") Long var3);

    @Select(value={"SELECT count(distinct(keyVal)) from ${table} where fieldName=#{fieldName} and stringVal=#{val}"})
    public int countForStringValue(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") String var3);

    @Select(value={"SELECT count(distinct(keyVal)) from ${table} where fieldName=#{fieldName} and longVal=#{val}"})
    public int countForLongValue(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") Long var3);

    @Select(value={"SELECT count(distinct(keyVal)) from ${table} where fieldName=#{fieldName} and doubleVal=#{val}"})
    public int countForDoubleValue(@Param(value="table") String var1, @Param(value="fieldName") String var2, @Param(value="val") Double var3);

    @Select(value={"SELECT distinct(stringVal) from ${table} where fieldName=#{fieldName}"})
    public List<String> selectDistinctStringVal(@Param(value="table") String var1, @Param(value="fieldName") String var2);

    @Select(value={"SELECT distinct(longVal) from ${table} where fieldName=#{fieldName}"})
    public List<Long> selectDistinctLongVal(@Param(value="table") String var1, @Param(value="fieldName") String var2);

    @Select(value={"SELECT distinct(doubleVal) from ${table} where fieldName=#{fieldName}"})
    public List<Double> selectDistinctDoubleVal(@Param(value="table") String var1, @Param(value="fieldName") String var2);

    @Select(value={"SELECT count(distinct(keyVal)) from ${table}"})
    public int count(@Param(value="table") String var1);

    @Select(value={"SELECT keyVal from ${table} where fieldName='CLASSNAME' order by keyVal limit #{startIndex}, #{endIndex}"})
    public List<String> findIDs(@Param(value="table") String var1, @Param(value="startIndex") int var2, @Param(value="endIndex") int var3);

    @Select(value={"SELECT keyVal from ${table} where fieldName='CREATIONTIME' and longVal>#{startTime} and longVal<#{endTime} order by keyVal "})
    public List<String> findIDsBetween(@Param(value="table") String var1, @Param(value="startTime") long var2, @Param(value="endTime") long var4);

    @Select(value={"SELECT distinct(keyVal) from ${table} where keyVal like #{id} order by keyVal limit #{amount} "})
    public List<String> findIdsLike(@Param(value="table") String var1, @Param(value="id") String var2, @Param(value="amount") int var3);

    @Transactional
    @Insert(value={"replace into ${table} values (#{row.created}, #{row.keyVal},#{row.fieldName},#{row.doubleVal},#{row.longVal},#{row.stringVal})"})
    @Options(flushCache=true)
    public void update(@Param(value="table") String var1, @Param(value="row") GenericRow var2);
}

