/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.domainmodel.Derivative;
import com.activequant.utils.annotations.Property;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Future
extends Derivative {
    private Long expiry;
    private Long firstTradingDate;
    private Long lastTradingDate;
    private Double lotSize;
    private Long rollDate;
    private Long settlementDate;
    private Double tickSize;
    private Double tickValue;

    public Future() {
        super(Future.class.getCanonicalName());
    }

    public Future(String instrumentId, String description, Long expiry, Double lotSize, Double tickSize, Double tickValue) {
        super(Future.class.getCanonicalName());
        super.setShortName(instrumentId);
        super.setDescription(description);
        this.expiry = expiry;
        this.lotSize = lotSize;
        this.tickSize = tickSize;
        this.tickValue = tickValue;
    }

    public double fullPointValue() {
        return 1.0 / this.tickSize * this.tickValue;
    }

    @Property
    public Long getExpiry() {
        return this.expiry;
    }

    @Property
    public Long getFirstTradingDate() {
        return this.firstTradingDate;
    }

    @Override
    public String getId() {
        return "FUT." + this.nullSafe(this.getExchangeCode()) + "." + this.nullSafe(this.getShortName()) + "." + this.nullSafe(this.expiry);
    }

    @Property
    public Long getLastTradingDate() {
        return this.lastTradingDate;
    }

    @Property
    public Double getLotSize() {
        return this.lotSize;
    }

    @Property
    public Long getRollDate() {
        return this.rollDate;
    }

    @Property
    public Long getSettlementDate() {
        return this.settlementDate;
    }

    @Override
    @Property
    public Double getTickSize() {
        return this.tickSize;
    }

    @Override
    @Property
    public Double getTickValue() {
        return this.tickValue;
    }

    public boolean isNowExpired() {
        Calendar cal = GregorianCalendar.getInstance();
        Long currentDate = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(cal.getTime()));
        return this.expiry < currentDate;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public void setFirstTradingDate(Long firstTradingDate) {
        this.firstTradingDate = firstTradingDate;
    }

    public void setLastTradingDate(Long lastTradingDate) {
        this.lastTradingDate = lastTradingDate;
    }

    public void setLotSize(Double lotSize) {
        this.lotSize = lotSize;
    }

    public void setRollDate(Long rollDate) {
        this.rollDate = rollDate;
    }

    public void setSettlementDate(Long settlementDate) {
        this.settlementDate = settlementDate;
    }

    @Override
    public void setTickSize(Double tickSize) {
        this.tickSize = tickSize;
    }

    @Override
    public void setTickValue(Double tickValue) {
        this.tickValue = tickValue;
    }
}

