/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.domainmodel.Instrument;
import com.activequant.domainmodel.exceptions.NoEntryForDate;
import com.activequant.utils.annotations.Property;

public class InstrumentChain
extends Instrument {
    private Long[] rollDates;
    private String[] validInstrument;

    public InstrumentChain() {
        super(InstrumentChain.class.getCanonicalName());
    }

    public String getValidInstrument(Long date8) throws NoEntryForDate {
        assert (date8 != null);
        String ret = null;
        for (int i = 0; i < this.rollDates.length; ++i) {
            if (this.rollDates[i] > date8) {
                return ret;
            }
            ret = this.validInstrument[i];
        }
        throw new NoEntryForDate(date8.toString());
    }

    @Override
    public String getId() {
        return "INST_CHAIN." + this.getName();
    }

    @Property
    public Long[] getRollDates() {
        return this.rollDates;
    }

    @Property
    public String[] getValidInstrument() {
        return this.validInstrument;
    }

    public void setRollDates(Long[] rollDates) {
        this.rollDates = rollDates;
    }

    public void setValidInstrument(String[] validInstrument) {
        this.validInstrument = validInstrument;
    }

    @Override
    public String toString() {
        return this.getId() + "/" + this.getName();
    }
}

