/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.utils.annotations.Property;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class PersistentEntity {
    private String className;
    private long creationTime = System.currentTimeMillis();
    private long deletionTime = 0L;
    private long snapshotTime = 0L;
    private static Logger log = Logger.getLogger(PersistentEntity.class);
    private Map<String, Object> underlyingMap = new HashMap<String, Object>();

    public PersistentEntity() {
    }

    protected void clearMap() {
        this.underlyingMap.clear();
    }

    public PersistentEntity(String className) {
        this.className = className;
    }

    @Property
    public String getClassName() {
        return this.className;
    }

    @Property
    public long getCreationTime() {
        return this.creationTime;
    }

    @Property
    public long getDeletionTime() {
        return this.deletionTime;
    }

    public abstract String getId();

    @Property
    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public Object convertValueToType(Class<?> targetType, Object input) {
        if (input.getClass().isAssignableFrom(targetType)) {
            return input;
        }
        if (targetType.isAssignableFrom(Double.TYPE) || targetType.isAssignableFrom(Double.class)) {
            if (input.getClass().isAssignableFrom(String.class)) {
                return Double.parseDouble(input.toString());
            }
        } else if ((targetType.isAssignableFrom(Long.TYPE) || targetType.isAssignableFrom(Long.class)) && input.getClass().isAssignableFrom(String.class)) {
            return Long.parseLong(input.toString());
        }
        return input;
    }

    public void initFromMap(Map<String, Object> inMap) {
        Method setter;
        this.underlyingMap = new HashMap<String, Object>(inMap);
        Method[] methods = this.getClass().getMethods();
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method m : methods) {
            String propertyName;
            if (m.getName().startsWith("get") && m.isAnnotationPresent(Property.class)) {
                propertyName = m.getName().substring(3).toUpperCase();
                if (!this.underlyingMap.containsKey(propertyName)) continue;
                Class<?> returnType = m.getReturnType();
                Object value = this.underlyingMap.get(propertyName);
                try {
                    setter = this.getClass().getMethod("set" + m.getName().substring(3), returnType);
                    if (value == null) continue;
                    Object convertedType = this.convertValueToType(returnType, value);
                    setter.invoke((Object)this, convertedType);
                }
                catch (Exception ex) {
                    log.warn((Object)("Could not set " + m.getName().substring(3) + " for value :" + value));
                    ex.printStackTrace();
                }
                continue;
            }
            if (!m.getName().startsWith("set")) continue;
            propertyName = m.getName().substring(3).toUpperCase();
            methodMap.put(propertyName, m);
        }
        Iterator<Map.Entry<String, Object>> entries = inMap.entrySet().iterator();
        HashMap<String, Object[]> arrayMap = new HashMap<String, Object[]>();
        while (entries.hasNext()) {
            Class<?>[] params;
            Map.Entry<String, Object> entry = entries.next();
            if (!entry.getKey().startsWith("[")) continue;
            String[] s = entry.getKey().split(";");
            String key = s[0].substring(1);
            int position = Integer.valueOf(s[1]);
            int totalAmount = Integer.valueOf(s[2]);
            if (!arrayMap.containsKey(key) && (params = (setter = (Method)methodMap.get(key)).getParameterTypes()) != null && params.length == 1) {
                Object array = Array.newInstance(params[0].getComponentType(), totalAmount);
                arrayMap.put(key, (Object[])array);
            }
            if (!arrayMap.containsKey(key)) continue;
            Object[] array = (Object[])arrayMap.get(key);
            array[position] = entry.getValue();
        }
        for (Map.Entry entry : arrayMap.entrySet()) {
            Method m = (Method)methodMap.get(entry.getKey());
            if (m == null) continue;
            try {
                Object[] obj = (Object[])entry.getValue();
                m.invoke((Object)this, new Object[]{obj});
            }
            catch (Exception ex) {
                log.warn((Object)("Could not set " + m.getName().substring(3) + " for value :" + entry.getValue()));
                ex.printStackTrace();
            }
        }
    }

    public String nullSafe(Object val) {
        if (val == null) {
            return "<NA>";
        }
        return val.toString();
    }

    public Map<String, Object> propertyMap() {
        Method[] methods;
        this.underlyingMap.clear();
        for (Method m : methods = this.getClass().getMethods()) {
            if (!m.getName().startsWith("get") || !m.isAnnotationPresent(Property.class)) continue;
            try {
                String propertyName = m.getName().substring(3).toUpperCase();
                Object value = m.invoke((Object)this, new Object[0]);
                this.underlyingMap.put(propertyName, value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(this.underlyingMap);
        return ret;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setDeletionTime(long deletionTime) {
        this.deletionTime = deletionTime;
    }

    public void setSnapshotTime(long snapshotTime) {
        this.snapshotTime = snapshotTime;
    }
}

