/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.domainmodel.exceptions.NoEntryForDate;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.dao.DataIntegrityViolationException;

public class RollingSchedule
extends TreeMap<Long, String> {
    private static final long serialVersionUID = 1L;

    public RollingSchedule(Long[] rollDates, String[] validInstrumentIds) {
        assert (rollDates.length == validInstrumentIds.length);
        if (rollDates.length != validInstrumentIds.length) {
            throw new DataIntegrityViolationException("Length mismatch");
        }
        for (int i = 0; i < rollDates.length; ++i) {
            if (rollDates[i] == null || validInstrumentIds[i] == null) continue;
            this.put(rollDates[i], validInstrumentIds[i]);
        }
    }

    public String getValidInstrument(Long date8) throws NoEntryForDate {
        assert (date8 != null);
        Iterator it = this.entrySet().iterator();
        String ret = null;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if ((Long)e.getKey() > date8) {
                return ret;
            }
            ret = (String)e.getValue();
        }
        throw new NoEntryForDate(date8.toString());
    }
}

