/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.domainmodel.SecurityChain;
import com.activequant.domainmodel.Tuple;
import com.activequant.utils.annotations.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SecurityChainByDate
extends SecurityChain {
    private Long[] rollDates = new Long[0];
    private String[] validInstrumentIds = new String[0];
    private Long lastHistFetchTime = null;
    private Long lastChainUpdateTime = null;

    public SecurityChainByDate() {
        super(SecurityChainByDate.class.getCanonicalName());
    }

    public void add(String instrumentId, Long rollDate8) {
        ArrayList<Tuple<Long, String>> chainList = new ArrayList<Tuple<Long, String>>();
        for (int i = 0; i < this.rollDates.length; ++i) {
            if (this.rollDates[i] == rollDate8) continue;
            chainList.add(new Tuple<Long, String>(this.rollDates[i], this.validInstrumentIds[i]));
        }
        chainList.add(new Tuple<Long, String>(rollDate8, instrumentId));
        this.sortAndSetChainList(chainList);
    }

    public void add(String[] instrumentId, Long[] rollDate8) {
        for (int i = 0; i < instrumentId.length; ++i) {
            this.add(instrumentId[i], rollDate8[i]);
        }
    }

    private void sortAndSetChainList(List<Tuple<Long, String>> chainList) {
        Collections.sort(chainList, new Comparator<Tuple<Long, String>>(){

            @Override
            public int compare(Tuple<Long, String> o1, Tuple<Long, String> o2) {
                return (int)(o1.getA() - o2.getA());
            }
        });
        this.rollDates = new Long[chainList.size()];
        this.validInstrumentIds = new String[chainList.size()];
        for (int i = 0; i < chainList.size(); ++i) {
            this.rollDates[i] = chainList.get(i).getA();
            this.validInstrumentIds[i] = chainList.get(i).getB();
        }
    }

    @Override
    public String getId() {
        return "SECCHAIN.DATE." + super.getChainName();
    }

    @Property
    public Long[] getRollDates() {
        return this.rollDates;
    }

    public void setRollDates(Long[] rollDates) {
        this.rollDates = rollDates;
    }

    @Property
    public String[] getValidInstrumentIDs() {
        return this.validInstrumentIds;
    }

    public void setValidInstrumentIDs(String[] validInstrument) {
        this.validInstrumentIds = validInstrument;
    }

    @Property
    public Long getLastHistFetchTime() {
        return this.lastHistFetchTime;
    }

    public void setLastHistFetchTime(Long lastHistFetchTime) {
        this.lastHistFetchTime = lastHistFetchTime;
    }

    @Property
    public Long getLastChainUpdateTime() {
        return this.lastChainUpdateTime;
    }

    public void setLastChainUpdateTime(Long lastChainUpdateTime) {
        this.lastChainUpdateTime = lastChainUpdateTime;
    }
}

