/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.domainmodel;

import com.activequant.utils.IdentityUtils;
import java.io.Serializable;
import java.sql.Time;
import java.util.Date;

public final class TimeStamp
implements Comparable<TimeStamp>,
Serializable {
    private static final long serialVersionUID = 5410311294683068489L;
    private static final long NANOS_IN_MILLIS = 1000000L;
    private final long value;
    private final int hashCode;

    public long getNanoseconds() {
        return this.value;
    }

    public long getMilliseconds() {
        return this.value / 1000000L;
    }

    public Date getDate() {
        return new Date(this.value / 1000000L);
    }

    public TimeStamp(long value) {
        this.value = value;
        this.hashCode = TimeStamp.computeHashCode(value);
    }

    public TimeStamp(Date dateValue, int nanos) {
        if (nanos < 0 || (long)nanos >= 1000000L) {
            throw new IllegalArgumentException("nanosecond part must be between 0 and 999999");
        }
        this.value = dateValue.getTime() * 1000000L + (long)nanos;
        this.hashCode = TimeStamp.computeHashCode(this.value);
    }

    private static final int computeHashCode(Long value) {
        return TimeStamp.class.getName().hashCode() + value.hashCode();
    }

    public TimeStamp(Date dateValue) {
        this(dateValue, 0);
    }

    public TimeStamp() {
        this(new Date());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(TimeStamp other) {
        return IdentityUtils.safeCompare(this.value, other.value);
    }

    public boolean equals(Object other) {
        return IdentityUtils.equalsTo(this, other);
    }

    public boolean isBefore(TimeStamp other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(TimeStamp other) {
        return this.compareTo(other) > 0;
    }

    public boolean isEqual(TimeStamp other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public Time getTimeComponent() {
        return new Time(this.getDate().getTime() % 86400000L);
    }

    public TimeStamp addDays(long days) {
        return new TimeStamp(this.value + days * 1000L * 1000L * 1000L * 60L * 60L * 24L);
    }
}

