/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.server;

import com.activequant.server.LocalHBaseCluster;
import com.activequant.server.LocalHSQLDBServer;
import com.activequant.server.LocalJMSServer;
import com.activequant.server.LocalSoapServer;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class AQ2Server {
    private LocalSoapServer ss;
    private Logger log = Logger.getLogger(AQ2Server.class);
    private boolean runFlag = true;

    private void printBanner() throws InterruptedException {
        String banner = "   \n ______     ______     ______   __     __   __   ______\n/\\  __ \\   /\\  ___\\   /\\__  _\\ /\\ \\   /\\ \\ / /  /\\  ___\\   \n\\ \\  __ \\  \\ \\ \\____  \\/_/\\ \\/ \\ \\ \\  \\ \\ \\'/   \\ \\  __\\   \n \\ \\_\\ \\_\\  \\ \\_____\\    \\ \\_\\  \\ \\_\\  \\ \\__|    \\ \\_____\\ \n  \\/_/\\/_/   \\/_____/     \\/_/   \\/_/   \\/_/      \\/_____/ \n                                                           \n ______     __  __     ______     __   __     ______  \n/\\  __ \\   /\\ \\/\\ \\   /\\  __ \\   /\\ -.\\ \\   /\\__  _\\ \n\\ \\ \\/\\_\\  \\ \\ \\_\\ \\  \\ \\  __ \\  \\ \\ \\-.  \\  \\/_/\\ \\/ \n \\ \\___\\_\\  \\ \\_____\\  \\ \\_\\ \\_\\  \\ \\_\\\\\\_\\    \\ \\_\\ \n  \\/___/_/   \\/_____/   \\/_/\\/_/   \\/_/ \\/_/     \\/_/ \n                                                      \n __   __     ______     ______     ______   ______     ______\n/\\ -./  \\   /\\  __ \\   /\\  ___\\   /\\__  _\\ /\\  ___\\   /\\  == \\   \n\\ \\ \\-./\\ \\  \\ \\  __ \\  \\ \\___  \\  \\/_/\\ \\/ \\ \\  __\\   \\ \\  __<   \n \\ \\_\\ \\ \\_\\  \\ \\_\\ \\_\\  \\/\\_____\\    \\ \\_\\  \\ \\_____\\  \\ \\_\\ \\_\\ \n  \\/_/  \\/_/   \\/_/\\/_/   \\/_____/     \\/_/   \\/_____/   \\/_/ /_/ \n                                                                  \n\n ______     ______     ______     __   __   ______     ______\n/\\  ___\\   /\\  ___\\   /\\  == \\   /\\ \\ / /  /\\  ___\\   /\\  == \\   \n\\ \\___  \\  \\ \\  __\\   \\ \\  __<   \\ \\ \\'/   \\ \\  __\\   \\ \\  __<   \n \\/\\_____\\  \\ \\_____\\  \\ \\_\\ \\_\\  \\ \\__|    \\ \\_____\\  \\ \\_\\ \\_\\ \n  \\/_____/   \\/_____/   \\/_/ /_/   \\/_/      \\/_____/   \\/_/ /_/ \n";
        System.out.println(banner);
        System.out.println("Initializing system ... ");
        Thread.sleep(3000L);
    }

    public AQ2Server() throws Exception {
        this.printBanner();
        this.log.info((Object)"Loading aq2server.properties from classpath.");
        Properties properties = new Properties();
        properties.load(new FileInputStream("aq2server.properties"));
        this.log.info((Object)"Loaded.");
        if (this.isTrue(properties, "soapserver.start")) {
            this.log.info((Object)"Starting soap server ....");
            this.ss = new LocalSoapServer(properties.getProperty("soapserver.hostname"), Integer.parseInt(properties.getProperty("soapserver.port")));
            this.ss.start();
            this.log.info((Object)"Starting soap server succeeded.");
        } else {
            this.log.info((Object)"Not starting soap server, as it has been disabled.");
        }
        if (this.isTrue(properties, "hbase.start")) {
            this.log.info((Object)"Starting mighty HBase ....");
            new LocalHBaseCluster().start();
            this.log.info((Object)"Starting HBase succeeded.");
        } else {
            this.log.info((Object)"Not starting HBase server, as it has been disabled.");
        }
        if (this.isTrue(properties, "activemq.start")) {
            this.log.info((Object)"Starting JMS ....");
            new LocalJMSServer().start(properties.getProperty("activemq.hostname"), Integer.parseInt(properties.getProperty("activemq.port")));
            this.log.info((Object)"Starting JMS succeeded.");
        } else {
            this.log.info((Object)"Not starting JMS server, as it has been disabled.");
        }
        if (this.isTrue(properties, "hsqldb.start")) {
            this.log.info((Object)"Starting HSQLDB ....");
            new LocalHSQLDBServer().start(Integer.parseInt(properties.getProperty("hsqldb.port")));
            this.log.info((Object)"Starting HSQLDB succeeded.");
        } else {
            this.log.info((Object)"Not starting HSQDLB server, as it has been disabled.");
        }
        while (this.runFlag) {
            Thread.sleep(250L);
        }
    }

    private boolean isTrue(Properties properties, String key) {
        return properties.containsKey(key) && properties.getProperty(key).equals("true");
    }

    public void stop() {
        this.runFlag = false;
    }

    public static void main(String[] args) throws Exception {
        new AQ2Server();
    }

    public LocalSoapServer getSoapServer() {
        return this.ss;
    }
}

