/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.server;

import com.activequant.dao.IDaoFactory;
import com.activequant.servicelayer.soap.MainService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class LocalSoapServer {
    private final int port;
    private final String hostName;
    private final IDaoFactory idf;

    public LocalSoapServer(String hostName, int port) {
        this.port = port;
        this.hostName = hostName;
        ClassPathXmlApplicationContext appContext2 = new ClassPathXmlApplicationContext("fwspring.xml");
        this.idf = (IDaoFactory)appContext2.getBean("ibatisDao");
    }

    public void start() throws Exception {
        JettyHTTPServerEngineFactory eg = new JettyHTTPServerEngineFactory();
        eg.createJettyHTTPServerEngine(this.port, "http");
        MainService implementor = new MainService(this.idf);
        Endpoint ep = Endpoint.publish((String)("http://" + this.hostName + ":" + this.port + "/aq2o"), (Object)implementor);
        SOAPBinding soap = (SOAPBinding)ep.getBinding();
        soap.setMTOMEnabled(true);
    }

    public void addService(String serviceSuburl, Object serviceImplementor) {
        Endpoint ep = Endpoint.publish((String)("http://" + this.hostName + ":" + this.port + "/" + serviceSuburl), (Object)serviceImplementor);
        SOAPBinding soap = (SOAPBinding)ep.getBinding();
        soap.setMTOMEnabled(true);
    }
}

