/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.servicelayer.matlab;

import com.activequant.domainmodel.TimeStamp;
import com.activequant.exceptions.InvalidDate8Time6Input;
import com.activequant.servicelayer.matlab.Parameter;
import com.activequant.servicelayer.matlab.ReturnMapProcessor;
import com.activequant.servicelayer.matlab.TimeSeriesContainer;
import com.activequant.servicelayer.matlab.TimeStampProcessor;
import com.activequant.utils.Date8Time6Parser;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Converters {
    private double offset = 719529.0;

    public TimeSeriesContainer convertDataMap(List<TimeStamp> timeStamps, Map<String, Map<String, Map<TimeStamp, Double>>> dataMap, String[] marketInstrumentIds, String[] fieldNames, Map<Parameter, Object> paramMap) throws InvalidDate8Time6Input, ParseException {
        int i;
        timeStamps = new TimeStampProcessor().processTimeStampList(timeStamps, paramMap);
        Collections.sort(timeStamps);
        Date8Time6Parser parser = new Date8Time6Parser();
        TimeSeriesContainer ret = new TimeSeriesContainer();
        double[] matlabTS = new double[timeStamps.size()];
        for (i = 0; i < timeStamps.size(); ++i) {
            double milliseconds = (double)timeStamps.get(i).getNanoseconds() / 1000000.0;
            matlabTS[i] = milliseconds / 1000.0 / 86400.0 + this.offset;
        }
        ret.timeStamps(matlabTS);
        ret.values(new double[marketInstrumentIds.length][timeStamps.size()][fieldNames.length]);
        for (i = 0; i < marketInstrumentIds.length; ++i) {
            String instrument = marketInstrumentIds[i];
            Map<String, Map<TimeStamp, Double>> instrumentMap = dataMap.get(instrument);
            for (int j = 0; j < fieldNames.length; ++j) {
                String field = fieldNames[j];
                Map<TimeStamp, Double> fieldMap = instrumentMap.get(field);
                for (int k = 0; k < timeStamps.size(); ++k) {
                    TimeStamp date8time6 = timeStamps.get(k);
                    ret.values()[i][k][j] = fieldMap.containsKey(date8time6) ? fieldMap.get(date8time6) : Double.NaN;
                }
            }
        }
        ret.values(new ReturnMapProcessor().processTimeStampList(ret.values(), paramMap));
        return ret;
    }
}

