/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.servicelayer.matlab;

import com.activequant.archive.IArchiveFactory;
import com.activequant.archive.TSContainer;
import com.activequant.archive.hbase.HBaseArchiveFactory;
import com.activequant.dao.DaoException;
import com.activequant.dao.IDaoFactory;
import com.activequant.domainmodel.Instrument;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.domainmodel.TimeFrame;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.servicelayer.matlab.Converters;
import com.activequant.servicelayer.matlab.InterpolationRule;
import com.activequant.servicelayer.matlab.Parameter;
import com.activequant.servicelayer.matlab.TimeSeriesContainer;
import com.activequant.utils.Date8Time6Parser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MatlabServiceFacade {
    private IArchiveFactory archiveFactory;
    private Logger log = Logger.getLogger(MatlabServiceFacade.class);
    private Date8Time6Parser d8t6p = new Date8Time6Parser();
    private Converters converter = new Converters();
    private IDaoFactory daoFactory;

    public MatlabServiceFacade() {
        this("localhost");
    }

    public MatlabServiceFacade(String zookeeperHost) {
        this.log.info((Object)"Instantiating new archive factory.");
        this.archiveFactory = new HBaseArchiveFactory(zookeeperHost);
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("fwspring.xml");
        this.daoFactory = (IDaoFactory)appContext.getBean("ibatisDao");
    }

    public MatlabServiceFacade(IArchiveFactory af, IDaoFactory dao) {
        this.log.info((Object)"Instantiating new archive factory.");
        this.archiveFactory = af;
        this.daoFactory = dao;
    }

    public String[] getInstrumentIds() throws DaoException {
        return this.daoFactory.instrumentDao().loadIDs();
    }

    public Instrument loadInstrument(String instrumentId) throws DaoException {
        return (Instrument)this.daoFactory.instrumentDao().load(instrumentId);
    }

    public MarketDataInstrument[] loadMarketDataInstruments(Instrument instrument) {
        return this.daoFactory.mdiDao().findFor(instrument);
    }

    public String getIID(String mdiId) throws DaoException {
        MarketDataInstrument mdi = (MarketDataInstrument)this.daoFactory.mdiDao().load(mdiId);
        if (mdi != null) {
            return mdi.getInstrumentId();
        }
        return null;
    }

    public MarketDataInstrument loadMarketDataInstrument(String mdiId) throws DaoException {
        return (MarketDataInstrument)this.daoFactory.mdiDao().load(mdiId);
    }

    public TimeSeriesContainer fetchTSData(TimeFrame tf, String[] marketInstrumentIds, String[] fieldNames, double startDate8Time6, Map<Parameter, Object> paramMap) throws Exception {
        return this.fetchTSData(tf, marketInstrumentIds, fieldNames, startDate8Time6, (double)this.d8t6p.now(), paramMap);
    }

    public TimeSeriesContainer fetchTSData(TimeFrame tf, MarketDataInstrument[] marketInstruments, String[] fieldNames, double startDate8Time6, double endDate8Time6, Map<Parameter, Object> paramMap) throws Exception {
        String[] mdiIds = new String[marketInstruments.length];
        for (int i = 0; i < marketInstruments.length; ++i) {
            mdiIds[i] = marketInstruments[i].getId();
        }
        return this.fetchTSData(tf, mdiIds, fieldNames, startDate8Time6, endDate8Time6, paramMap);
    }

    public TimeSeriesContainer fetchTSData(TimeFrame tf, String[] marketInstrumentIds, String[] fieldNames, double startDate8Time6, double endDate8Time6, Map<Parameter, Object> paramMap) throws Exception {
        if (paramMap == null) {
            paramMap = new HashMap<Parameter, Object>();
        }
        Date8Time6Parser parser = new Date8Time6Parser();
        HashMap<String, Map<String, Map<TimeStamp, Double>>> dataMap = new HashMap<String, Map<String, Map<TimeStamp, Double>>>();
        ArrayList<TimeStamp> timeStamps = new ArrayList<TimeStamp>();
        for (int i = 0; i < marketInstrumentIds.length; ++i) {
            String instrument = marketInstrumentIds[i];
            if (!dataMap.containsKey(instrument)) {
                dataMap.put(instrument, new HashMap());
            }
            Map instrumentMap = (Map)dataMap.get(instrument);
            for (int j = 0; j < fieldNames.length; ++j) {
                String field = fieldNames[j];
                if (!instrumentMap.containsKey(field)) {
                    instrumentMap.put(field, new HashMap());
                }
                Map fieldMap = (Map)instrumentMap.get(field);
                TimeStamp t1 = new TimeStamp(parser.getNanoseconds(startDate8Time6));
                TimeStamp t2 = new TimeStamp(parser.getNanoseconds(endDate8Time6));
                TSContainer ts = this.archiveFactory.getReader(tf).getTimeSeries(instrument, field, t1, t2);
                if (ts.timeStamps.length <= 0) continue;
                for (int k = 0; k < ts.timeStamps.length; ++k) {
                    TimeStamp timeStamp = ts.timeStamps[k];
                    Double value = ts.values[k];
                    if (!timeStamps.contains(timeStamp)) {
                        timeStamps.add(timeStamp);
                    }
                    fieldMap.put(timeStamp, value);
                }
            }
        }
        return this.converter.convertDataMap(timeStamps, dataMap, marketInstrumentIds, fieldNames, paramMap);
    }

    public String facadeName() {
        return "ServiceFacade by Ulrich.";
    }

    public TimeSeriesContainer fetchTSData(TimeFrame tf, String marketInstrumentId, String fieldName, double startDate8Time6, Map<Parameter, Object> paramMap) throws Exception {
        return this.fetchTSData(tf, new String[]{marketInstrumentId}, new String[]{fieldName}, startDate8Time6, (double)this.d8t6p.now(), paramMap);
    }

    public TimeSeriesContainer fetchTSData(TimeFrame tf, String marketInstrumentId, String fieldName, double startDate8Time6, double endDate8Time6, Map<Parameter, Object> paramMap) throws Exception {
        return this.fetchTSData(tf, new String[]{marketInstrumentId}, new String[]{fieldName}, startDate8Time6, endDate8Time6, paramMap);
    }

    public static void main(String[] args) throws Exception {
        MatlabServiceFacade msf = new MatlabServiceFacade();
        HashMap<Parameter, Object> pMap = new HashMap<Parameter, Object>();
        pMap.put(Parameter.INTERPOLRULE, (Object)InterpolationRule.CARRY_FORWARD);
        TimeSeriesContainer data = msf.fetchTSData(TimeFrame.EOD, new String[]{"CSI_AD", "CSI_EURUSD"}, new String[]{"CLOSE"}, 2.0000701E13, 2.000071E13, pMap);
        msf.fetchTSData(TimeFrame.EOD, new String[]{"CSI_AD"}, new String[]{"OPEN", "CLOSE"}, 2.0000101E13, 2.0000105E13, null);
        System.out.println("Done");
    }
}

