/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.tools.mapping;

import com.activequant.dao.DaoException;
import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.tools.mapping.IMapper;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Mdi2InstrumentMapper {
    private IMarketDataInstrumentDao mdidao;
    private IMapper[] mappers;

    public Mdi2InstrumentMapper(IDaoFactory idf, IMapper[] mappers) throws DaoException {
        this.mdidao = idf.mdiDao();
        this.mappers = mappers;
        this.map();
    }

    private void map() throws DaoException {
        int totalMDIs = this.mdidao.count();
        int sliceSize = 200;
        int slices = totalMDIs / sliceSize + 1;
        for (int i = 0; i < slices; ++i) {
            String[] mdiIds;
            int startId = i * sliceSize;
            int endId = (i + 1) * sliceSize - 1;
            for (String mdiId : mdiIds = this.mdidao.findIDs(startId, endId)) {
                MarketDataInstrument mdi = (MarketDataInstrument)this.mdidao.load(mdiId);
                for (IMapper mapper : this.mappers) {
                    mapper.map(mdi);
                }
                this.mdidao.update(mdi);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String springFile = "automapper.xml";
        if (args.length == 1) {
            springFile = args[0];
        }
        new ClassPathXmlApplicationContext(springFile);
    }
}

