/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.tools.streaming;

import com.activequant.tools.streaming.IEventSink;
import com.activequant.tools.streaming.IEventSource;
import com.activequant.tools.streaming.StreamEvent;
import com.activequant.transport.ETransportType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEventChainLink
implements IEventSink,
IEventSource {
    private Map<ETransportType, List<IEventSink>> subscriberMap = new HashMap<ETransportType, List<IEventSink>>();

    public List<IEventSink> getSubscriberList(ETransportType type) {
        if (!this.subscriberMap.containsKey((Object)type)) {
            this.subscriberMap.put(type, new ArrayList());
        }
        return this.subscriberMap.get((Object)type);
    }

    @Override
    public void subscribe(IEventSink sink, ETransportType eventType) {
        this.getSubscriberList(eventType).add(sink);
    }

    @Override
    public void unsubscribe(IEventSink sink, ETransportType eventType) {
        this.getSubscriberList(eventType).remove(sink);
    }

    @Override
    public void process(StreamEvent se) {
        for (IEventSink sink : this.getSubscriberList(se.getEventType())) {
            sink.process(se);
        }
    }

    @Override
    public abstract void start();
}

