/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.tools.streaming;

import com.activequant.domainmodel.TimeStamp;
import com.activequant.tools.streaming.MarketDataEvent;
import com.activequant.transport.ETransportType;

public class BBOEvent
extends MarketDataEvent {
    private Double bid;
    private Double ask;
    private Double bidQuantity;
    private Double askQuantity;
    private String tradeableId;

    public BBOEvent(String mdiId, String tradeableId, TimeStamp ts, Double bid, Double bidQuantity, Double ask, Double askQuantity) {
        super(ts, BBOEvent.class.getCanonicalName(), mdiId);
        this.tradeableId = tradeableId;
        this.ask = ask;
        this.bid = bid;
        this.askQuantity = askQuantity;
        this.bidQuantity = bidQuantity;
    }

    @Override
    public ETransportType getEventType() {
        return ETransportType.MARKET_DATA;
    }

    public String getTradeableInstrumentId() {
        return this.tradeableId;
    }

    public Double getBid() {
        return this.bid;
    }

    public void setBid(Double bid) {
        this.bid = bid;
    }

    public Double getAsk() {
        return this.ask;
    }

    public void setAsk(Double ask) {
        this.ask = ask;
    }

    public Double getBidQuantity() {
        return this.bidQuantity;
    }

    public void setBidQuantity(Double bidQuantity) {
        this.bidQuantity = bidQuantity;
    }

    public Double getAskQuantity() {
        return this.askQuantity;
    }

    public void setAskQuantity(Double askQuantity) {
        this.askQuantity = askQuantity;
    }

    public String getTradeableId() {
        return this.tradeableId;
    }

    public void setTradeableId(String tradeableId) {
        this.tradeableId = tradeableId;
    }
}

