/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.trading;

import com.activequant.domainmodel.trade.order.Order;
import com.activequant.trading.IOrderBook;
import com.activequant.trading.orderbook.IOrderBookListener;
import com.activequant.trading.orderbook.MarketState;
import com.activequant.trading.orderbook.OrderBookChange;
import com.activequant.trading.orderbook.TransactionEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOrderBook<T extends Order>
implements IOrderBook<T> {
    private final String tradeableId;
    private MarketState marketState;
    private List<IOrderBookListener> orderBookListeners = new ArrayList<IOrderBookListener>();

    public AbstractOrderBook(String tradeableId) {
        this.tradeableId = tradeableId;
    }

    @Override
    public String getTradeableInstrumentId() {
        return this.tradeableId;
    }

    @Override
    public MarketState getMarketState() {
        return this.marketState;
    }

    @Override
    public void attachOrderBookListener(IOrderBookListener listener) {
        this.orderBookListeners.add(listener);
    }

    @Override
    public void detachOrderBookListener(IOrderBookListener listener) {
        this.orderBookListeners.remove(listener);
    }

    protected void orderBookEvent(OrderBookChange obc) {
        for (IOrderBookListener l : this.orderBookListeners) {
            l.orderBookChange(obc);
        }
    }

    protected void marketStateChange(MarketState newState) {
        this.marketState = newState;
        for (IOrderBookListener l : this.orderBookListeners) {
            l.marketStateChange(newState);
        }
    }

    protected void transaction(TransactionEvent te) {
        for (IOrderBookListener l : this.orderBookListeners) {
            l.transactionEvent(te);
        }
    }
}

