/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.trading.virtual;

import com.activequant.domainmodel.trade.order.LimitOrder;
import com.activequant.domainmodel.trade.order.OrderSide;
import com.activequant.domainmodel.trade.order.SingleLegOrder;
import com.activequant.trading.AbstractOrderBook;
import com.activequant.trading.orderbook.OrderBookUpdated;
import com.activequant.trading.virtual.LimitOrderBookMatcher;
import com.activequant.trading.virtual.VirtualExchange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class LimitOrderBook
extends AbstractOrderBook<LimitOrder> {
    private final String instrumentId;
    private List<LimitOrder> buySide = new ArrayList<LimitOrder>();
    private List<LimitOrder> sellSide = new ArrayList<LimitOrder>();
    private final LimitOrderBookMatcher matcher;
    private final VirtualExchange vex;

    public LimitOrderBook(VirtualExchange vex, String tradeableInstrumentId) {
        super(tradeableInstrumentId);
        this.instrumentId = tradeableInstrumentId;
        this.matcher = new LimitOrderBookMatcher(vex, this);
        this.vex = vex;
    }

    public void match() {
        this.matcher.match();
    }

    void weedOutForeignOrders() {
        LimitOrder lo;
        Iterator<LimitOrder> it = this.buySide.iterator();
        while (it.hasNext()) {
            lo = it.next();
            if (lo.getOrderId() != null) continue;
            it.remove();
        }
        it = this.sellSide.iterator();
        while (it.hasNext()) {
            lo = it.next();
            if (lo.getOrderId() != null) continue;
            it.remove();
        }
    }

    public void addOrders(LimitOrder[] orders) {
        for (LimitOrder order : orders) {
            if (order.getOrderSide().equals(OrderSide.BUY)) {
                this.buySide.add(order);
                continue;
            }
            if (!order.getOrderSide().equals(OrderSide.SELL)) continue;
            this.sellSide.add(order);
        }
        this.resortBuySide();
        this.resortSellSide();
        super.orderBookEvent(new OrderBookUpdated());
    }

    public void addOrder(LimitOrder order) {
        if (order.getOrderSide().equals(OrderSide.BUY)) {
            this.buySide.add(order);
            this.resortBuySide();
        } else if (order.getOrderSide().equals(OrderSide.SELL)) {
            this.sellSide.add(order);
            this.resortSellSide();
        }
        if (order.getWorkingTimeStamp() == null) {
            order.setWorkingTimeStamp(this.vex.currentExchangeTime());
        }
        super.orderBookEvent(new OrderBookUpdated());
    }

    public void cancelOrder(SingleLegOrder order) {
        if (order.getOrderSide().equals(OrderSide.BUY)) {
            this.buySide.remove(order);
            this.resortBuySide();
        } else if (order.getOrderSide().equals(OrderSide.SELL)) {
            this.sellSide.remove(order);
            this.resortSellSide();
        }
        super.orderBookEvent(new OrderBookUpdated());
    }

    private void resortBuySide() {
        Collections.sort(this.buySide, new Comparator<LimitOrder>(){

            @Override
            public int compare(LimitOrder o1, LimitOrder o2) {
                return (int)(o2.getLimitPrice() - o1.getLimitPrice());
            }
        });
    }

    private void resortSellSide() {
        Collections.sort(this.sellSide, new Comparator<LimitOrder>(){

            @Override
            public int compare(LimitOrder o1, LimitOrder o2) {
                return (int)(o1.getLimitPrice() - o2.getLimitPrice());
            }
        });
    }

    public void updateOrder(LimitOrder newOrder) {
        if (newOrder.getOrderSide().equals(OrderSide.BUY)) {
            int index = -1;
            for (int i = 0; i < this.buySide.size(); ++i) {
                if (this.buySide.get(i).getOrderId() != newOrder.getOrderId()) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.buySide.set(index, newOrder);
                this.resortBuySide();
            }
        } else if (newOrder.getOrderSide().equals(OrderSide.SELL)) {
            int index = -1;
            for (int i = 0; i < this.sellSide.size(); ++i) {
                if (this.sellSide.get(i).getOrderId() != newOrder.getOrderId()) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.sellSide.set(index, newOrder);
                this.resortSellSide();
            }
        }
        super.orderBookEvent(new OrderBookUpdated());
    }

    @Override
    public List<LimitOrder> buySide() {
        return this.buySide;
    }

    public void buySide(List<LimitOrder> buySide) {
        this.buySide = buySide;
    }

    @Override
    public List<LimitOrder> sellSide() {
        return this.sellSide;
    }

    public void sellSide(List<LimitOrder> sellSide) {
        this.sellSide = sellSide;
    }
}

