/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.trading.virtual;

import com.activequant.domainmodel.trade.order.LimitOrder;
import com.activequant.trading.virtual.LimitOrderBook;
import com.activequant.trading.virtual.VirtualExchange;
import java.util.List;

public class LimitOrderBookMatcher {
    private LimitOrderBook ob;
    private VirtualExchange exchange;

    public LimitOrderBookMatcher(VirtualExchange exchange, LimitOrderBook ob) {
        this.ob = ob;
        this.exchange = exchange;
    }

    public void match() {
        List<LimitOrder> buySide = this.ob.buySide();
        List<LimitOrder> sellSide = this.ob.sellSide();
        while (buySide.size() > 0 && sellSide.size() > 0 && buySide.get(0).getLimitPrice() >= sellSide.get(0).getLimitPrice()) {
            LimitOrder buyOrder = buySide.get(0);
            LimitOrder sellOrder = sellSide.get(0);
            double difference = buyOrder.getOpenQuantity() - sellOrder.getOpenQuantity();
            double executed = 0.0;
            double relevantPrice = sellOrder.getLimitPrice();
            if (buyOrder.getWorkingTimeStamp().compareTo(sellOrder.getWorkingTimeStamp()) < 0) {
                relevantPrice = buyOrder.getLimitPrice();
            }
            if (difference > 0.0) {
                executed = buyOrder.getOpenQuantity() + difference;
                buyOrder.setOpenQuantity(difference);
                sellOrder.setOpenQuantity(0.0);
            } else if (difference < 0.0) {
                executed = sellOrder.getOpenQuantity() + difference;
                buyOrder.setOpenQuantity(0.0);
                sellOrder.setOpenQuantity(Math.abs(difference));
            } else {
                executed = buyOrder.getOpenQuantity();
                sellOrder.setOpenQuantity(0.0);
                buyOrder.setOpenQuantity(0.0);
            }
            this.exchange.execution(buyOrder, relevantPrice, executed);
            this.exchange.execution(sellOrder, relevantPrice, executed);
            if (sellOrder.getOpenQuantity() == 0.0) {
                sellSide.remove(0);
            }
            if (buyOrder.getOpenQuantity() != 0.0) continue;
            buySide.remove(0);
        }
    }
}

