/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.trading.virtual;

import com.activequant.domainmodel.TimeStamp;
import com.activequant.domainmodel.trade.event.OrderEvent;
import com.activequant.domainmodel.trade.event.OrderFillEvent;
import com.activequant.domainmodel.trade.event.OrderTerminalEvent;
import com.activequant.domainmodel.trade.order.LimitOrder;
import com.activequant.domainmodel.trade.order.Order;
import com.activequant.domainmodel.trade.order.OrderSide;
import com.activequant.exceptions.IncompleteOrderInstructions;
import com.activequant.exceptions.UnsupportedOrderType;
import com.activequant.tools.streaming.BBOEvent;
import com.activequant.tools.streaming.StreamEvent;
import com.activequant.tools.streaming.TimeStreamEvent;
import com.activequant.trading.IOrderTracker;
import com.activequant.trading.virtual.IExchange;
import com.activequant.trading.virtual.LimitOrderBook;
import com.activequant.utils.events.Event;
import com.activequant.utils.events.IEventSource;
import java.util.HashMap;
import java.util.Map;

public class VirtualExchange
implements IExchange {
    private long virtexOrderId = 0L;
    private TimeStamp currentExchangeTime = new TimeStamp(0L);
    private Map<String, IOrderTracker> orderTrackers = new HashMap<String, IOrderTracker>();
    private Map<String, LimitOrderBook> lobs = new HashMap<String, LimitOrderBook>();

    @Override
    public TimeStamp currentExchangeTime() {
        return this.currentExchangeTime;
    }

    @Override
    public IOrderTracker prepareOrder(Order order) throws UnsupportedOrderType, IncompleteOrderInstructions {
        if (!(order instanceof LimitOrder)) {
            throw new UnsupportedOrderType("Order type not supported by exchange: " + order);
        }
        LimitOrder limitOrder = (LimitOrder)order;
        if (limitOrder.getQuantity() <= 0.0) {
            throw new IncompleteOrderInstructions("Invalid quantity given: " + limitOrder.getQuantity());
        }
        if (limitOrder.getLimitPrice() == null) {
            throw new IncompleteOrderInstructions("No limit price given.");
        }
        if (limitOrder.getLimitPrice() <= 0.0) {
            throw new IncompleteOrderInstructions("Invalid negative limit price given.");
        }
        VirtualOrderTracker tracker = new VirtualOrderTracker(limitOrder);
        return tracker;
    }

    public IOrderTracker getOrderTracker(Order order) {
        IOrderTracker tracker = this.orderTrackers.get(order.getOrderId());
        return tracker;
    }

    public void execution(Order order, double price, double quantity) {
        if (order.getOrderId() == null) {
            return;
        }
        IOrderTracker trck = this.getOrderTracker(order);
        if (trck == null) {
            return;
        }
        if (trck instanceof VirtualOrderTracker) {
            LimitOrder lo;
            OrderFillEvent ofe = new OrderFillEvent();
            ofe.setCreationTimeStamp(this.currentExchangeTime());
            ofe.setFillAmount(quantity);
            ofe.setFillPrice(price);
            ((VirtualOrderTracker)trck).getEvent().fire(ofe);
            if (order instanceof LimitOrder && (lo = (LimitOrder)order).getOpenQuantity() == 0.0) {
                OrderTerminalEvent ote = new OrderTerminalEvent();
                ote.setCreationTimeStamp(this.currentExchangeTime());
                ((VirtualOrderTracker)trck).getEvent().fire(ote);
                this.orderTrackers.remove(trck);
            }
        }
    }

    @Override
    public void processStreamEvent(StreamEvent streamEvent) {
        if (streamEvent instanceof TimeStreamEvent) {
            this.currentExchangeTime = ((TimeStreamEvent)streamEvent).getTimeStamp();
        }
        if (streamEvent instanceof BBOEvent) {
            BBOEvent nbbo = (BBOEvent)streamEvent;
            String instId = nbbo.getTradeableInstrumentId();
            if (instId == null) {
                return;
            }
            LimitOrderBook lob = this.getOrderBook(instId);
            lob.weedOutForeignOrders();
            if (nbbo.getBid() != null) {
                LimitOrder bestBid = new LimitOrder();
                bestBid.setOrderSide(OrderSide.BUY);
                bestBid.setLimitPrice(nbbo.getBid());
                bestBid.setQuantity(nbbo.getBidQuantity());
                bestBid.setOpenQuantity(bestBid.getQuantity());
                lob.addOrder(bestBid);
            }
            if (nbbo.getAsk() != null) {
                LimitOrder bestAsk = new LimitOrder();
                bestAsk.setOrderSide(OrderSide.SELL);
                bestAsk.setLimitPrice(nbbo.getAsk());
                bestAsk.setQuantity(nbbo.getAskQuantity());
                bestAsk.setOpenQuantity(bestAsk.getQuantity());
                lob.addOrder(bestAsk);
            }
            lob.match();
        }
    }

    @Override
    public LimitOrderBook getOrderBook(String tradeableInstrumentId) {
        if (!this.lobs.containsKey(tradeableInstrumentId)) {
            this.lobs.put(tradeableInstrumentId, new LimitOrderBook(this, tradeableInstrumentId));
        }
        return this.lobs.get(tradeableInstrumentId);
    }

    class VirtualOrderTracker
    implements IOrderTracker {
        private Event<OrderEvent> event = new Event();
        private LimitOrder order;

        VirtualOrderTracker(LimitOrder order) throws IncompleteOrderInstructions {
            this.order = order;
            if (order.getTradInstId() == null) {
                throw new IncompleteOrderInstructions("TradInstID missing");
            }
        }

        public Event<OrderEvent> getEvent() {
            return this.event;
        }

        @Override
        public void update(Order newOrder) {
            VirtualExchange.this.getOrderBook(this.order.getTradInstId()).updateOrder(this.order);
        }

        @Override
        public void submit() {
            VirtualExchange.this.getOrderBook(this.order.getTradInstId()).addOrder(this.order);
            this.order.setOpenQuantity(this.order.getQuantity());
            this.order.setWorkingTimeStamp(VirtualExchange.this.currentExchangeTime());
            if (this.order.getOrderId() == null) {
                this.order.setOrderId("OID" + VirtualExchange.this.virtexOrderId++);
            }
            VirtualExchange.this.orderTrackers.put(this.order.getOrderId(), this);
        }

        @Override
        public String getVenueAssignedId() {
            return "VIRTEXOID" + VirtualExchange.this.virtexOrderId++;
        }

        @Override
        public IEventSource<OrderEvent> getOrderEventSource() {
            return this.event;
        }

        @Override
        public Order getOrder() {
            return this.order;
        }

        @Override
        public void cancel() {
            VirtualExchange.this.getOrderBook(this.order.getTradInstId()).cancelOrder(this.order);
        }
    }
}

