/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.trading.virtual;

import com.activequant.domainmodel.trade.event.OrderEvent;
import com.activequant.domainmodel.trade.event.OrderSubmittedEvent;
import com.activequant.domainmodel.trade.order.Order;
import com.activequant.trading.IOrderTracker;
import com.activequant.trading.virtual.IExchange;
import com.activequant.utils.events.Event;
import com.activequant.utils.events.IEventSource;

class VirtualOrderTracker
implements IOrderTracker {
    private final IExchange exchange;
    private final Order order;
    private final Event<OrderEvent> event = new Event();
    private final String venueAssignedId;

    VirtualOrderTracker(IExchange exchange, String venueAssignedId, Order order) {
        this.exchange = exchange;
        this.order = order;
        this.venueAssignedId = venueAssignedId;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public String getVenueAssignedId() {
        return this.venueAssignedId;
    }

    @Override
    public void submit() {
        OrderSubmittedEvent oe = new OrderSubmittedEvent();
        oe.setCreationTimeStamp(this.exchange.currentExchangeTime());
        this.event.fire(oe);
    }

    @Override
    public void update(Order newOrder) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public IEventSource<OrderEvent> getOrderEventSource() {
        return this.event;
    }
}

