/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.transport.activemq;

import com.activequant.domainmodel.Instrument;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.domainmodel.TradeableInstrument;
import com.activequant.exceptions.TransportException;
import com.activequant.transport.ETransportType;
import com.activequant.transport.IPublisher;
import com.activequant.transport.IReceiver;
import com.activequant.transport.ITransportFactory;
import com.activequant.transport.activemq.JMSPublisher;
import com.activequant.transport.activemq.JMSReceiver;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

public class ActiveMQTransportFactory
implements ITransportFactory {
    private static ActiveMQConnectionFactory connectionFactory;
    private static Connection connection;
    private static Session session;
    private Logger log = Logger.getLogger((String)ActiveMQConnectionFactory.class.getName());
    private HashMap<String, IPublisher> publisherMap = new HashMap();
    private HashMap<String, IReceiver> receiverMap = new HashMap();

    public ActiveMQTransportFactory(String host, int port) throws Exception {
        String conUrl = "failover:tcp://" + host + ":" + port + "??wireFormat.maxInactivityDuration=0";
        this.log.info((Object)("Constructing ActiveMQTransportFactory for " + conUrl));
        connectionFactory = new ActiveMQConnectionFactory(conUrl);
        connectionFactory.setProducerWindowSize(1024000);
        connection = connectionFactory.createTopicConnection();
        connection.start();
        session = connection.createSession(false, 1);
    }

    public ActiveMQTransportFactory() throws Exception {
        String conUrl = "vm://localhost";
        this.log.info((Object)("Constructing embedded ActiveMQTransportFactory for " + conUrl));
        connectionFactory = new ActiveMQConnectionFactory(conUrl);
        connectionFactory.setProducerWindowSize(1024000);
        connection = connectionFactory.createTopicConnection();
        connection.start();
        session = connection.createSession(false, 1);
    }

    private void createPublisher(String destination) throws TransportException {
        String originalDestination = destination;
        if (destination.length() > 5) {
            destination = destination.substring(0, 4);
        }
        if (!this.publisherMap.containsKey(originalDestination)) {
            try {
                Topic topic = session.createTopic(destination);
                MessageProducer producer = session.createProducer((Destination)topic);
                JMSPublisher j = new JMSPublisher(session, producer, originalDestination);
                this.publisherMap.put(originalDestination, j);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Added publisher for " + originalDestination));
                }
            }
            catch (Exception ex) {
                throw new TransportException(ex);
            }
        }
    }

    private void createReceiver(String destination) throws TransportException {
        String originalDestination = destination;
        if (destination.length() > 5) {
            destination = destination.substring(0, 4);
        }
        if (!this.receiverMap.containsKey(originalDestination)) {
            try {
                Topic topic = session.createTopic(destination);
                MessageConsumer consumer = session.createConsumer((Destination)topic, "channelId='" + originalDestination + "'");
                JMSReceiver j = new JMSReceiver();
                consumer.setMessageListener((MessageListener)j);
                this.receiverMap.put(originalDestination, j);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Added receiver for " + originalDestination));
                }
            }
            catch (Exception ex) {
                throw new TransportException(ex);
            }
        }
    }

    @Override
    public synchronized IPublisher getPublisher(ETransportType transType, String id) throws TransportException {
        String destination = transType.toString() + "." + id;
        this.createPublisher(destination);
        return this.publisherMap.get(destination);
    }

    @Override
    public synchronized IReceiver getReceiver(ETransportType transType, String id) throws TransportException {
        String destination = transType.toString() + "." + id;
        this.createReceiver(destination);
        return this.receiverMap.get(destination);
    }

    @Override
    public synchronized IPublisher getPublisher(ETransportType transType, Instrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getId();
        this.createPublisher(destination);
        return this.publisherMap.get(destination);
    }

    @Override
    public synchronized IReceiver getReceiver(ETransportType transType, Instrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getId();
        this.createReceiver(destination);
        return this.receiverMap.get(destination);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, MarketDataInstrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getMdProvider() + "." + instrument.getProviderSpecificId();
        this.createPublisher(destination);
        return this.publisherMap.get(destination);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, MarketDataInstrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getMdProvider() + "." + instrument.getProviderSpecificId();
        this.createReceiver(destination);
        return this.receiverMap.get(destination);
    }

    @Override
    public IPublisher getPublisher(String channel) throws TransportException {
        this.createPublisher(channel);
        return this.publisherMap.get(channel);
    }

    @Override
    public IReceiver getReceiver(String channel) throws TransportException {
        this.createReceiver(channel);
        return this.receiverMap.get(channel);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, TradeableInstrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getTradingProvider() + "." + instrument.getProviderSpecificId();
        this.createPublisher(destination);
        return this.publisherMap.get(destination);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, TradeableInstrument instrument) throws TransportException {
        String destination = transType.toString() + "." + instrument.getTradingProvider() + "." + instrument.getProviderSpecificId();
        this.createReceiver(destination);
        return this.receiverMap.get(destination);
    }
}

